/*
    Locale support implementation through OS/2 Unicode API.
    Copyright (c) 2003 InnoTek Systemberatung GmbH

    For conditions of distribution and use, see the file COPYING.

    Usually these routines are not needed (they are inline), but
    for cases when a program instead of including ctype.h blindly
    declares them with "extern", they will be linked in.
*/

#include "libc-alias.h"
#include <sys/locale.h>

int isalnum (int _c)
{ return __locale_ctype.cflags [_c & 0xff] & (__UPPER|__LOWER|__DIGIT); }

int isalpha (int _c)
{ return __locale_ctype.cflags [_c & 0xff] & (__UPPER|__LOWER); }

int iscntrl (int _c)
{ return __locale_ctype.cflags [_c & 0xff] & (__CNTRL); }

int isdigit (int _c)
{ return __locale_ctype.cflags [_c & 0xff] & (__DIGIT); }

int isgraph (int _c)
{ return __locale_ctype.cflags [_c & 0xff] & (__PUNCT|__UPPER|__LOWER|__DIGIT); }

int islower (int _c)
{ return __locale_ctype.cflags [_c & 0xff] & (__LOWER); }

int isprint (int _c)
{ return __locale_ctype.cflags [_c & 0xff] & (__PRINT); }

int ispunct (int _c)
{ return __locale_ctype.cflags [_c & 0xff] & (__PUNCT); }

int isspace (int _c)
{ return __locale_ctype.cflags [_c & 0xff] & (__SPACE); }

int isupper (int _c)
{ return __locale_ctype.cflags [_c & 0xff] & (__UPPER); }

int isxdigit (int _c)
{ return __locale_ctype.cflags [_c & 0xff] & (__XDIGIT); }

int toascii (int _c)
{ return _c & 0x7f; }

int isascii (int _c)
{ return (_c & 0x80) != 0; }
