/*
    Locale support implementation through OS/2 Unicode API.
    Copyright (c) 2003 InnoTek Systemberatung GmbH

    For conditions of distribution and use, see the file COPYING.

    Convert the null-terminated sequence of multibyte character pointed to
    by s to a sequence of wchar_t codes pointed to by pwcs. The multibyte
    character sequence starts in the initial shift state. At most n codes
    are stored to pwcs. pwcs will be terminated with a code of value zero
    if n is big enough. 

    The shift state of mbtowc() and mblen() is not affected. 

    mbstowcs() returns the number of codes stored to pwcs (excluding the
    terminating zero code) or (size_t)-1 if an invalid multibyte character
    is encountered.

    Affected by LC_CTYPE locale setting.

    BUGS: Currently shift states between calls to multibyte/widechar
    functions are lost.
*/

#define __INTERNAL_DEFS
#include "libc-alias.h"
#include <sys/locale.h>
#include <string.h>

size_t _STD(mbstowcs) (wchar_t *pwcs, const char *s, size_t n)
{
  size_t nonid, sl = strlen (s) + 1, nw = n;

  if (UniUconvToUcs (__locale_ctype.uconv, (void *)&s, &sl, &pwcs,
    &nw, &nonid))
    return -1;

  return n - nw - 1;
}
