/* strerror.c (emx+gcc) -- Copyright (c) 1990-1996 by Eberhard Mattes */

#include "libc-alias.h"
#include <stdlib.h>
#include <string.h>
#include <emx/thread.h>
#include <sys/errno.h>

char *_STD(strerror) (int errnum)
{
  if (errnum >= 0 && errnum < sys_nerr)
    return (char *)sys_errlist [errnum];
  else
    {
      static char msg[] = "Unknown error ";
      struct _thread *tp = _thread();
      memcpy (tp->_th_error, msg, sizeof (msg) - 1);
      _itoa (errnum, tp->_th_error + sizeof (msg) - 1, 10);
      return tp->_th_error;
    }
}
