/*
    Locale support implementation through OS/2 Unicode API.
    Copyright (c) 2003 InnoTek Systemberatung GmbH

    For conditions of distribution and use, see the file COPYING.

    Convert the wchar_t code wchar to a multibyte character sequence pointed
    to by s.At most MB_CUR_MAX bytes are stored. If s is NULL, the shift state
    is reset to the initial state. If wchar is zero, the shift state is the
    initial state after return from wctomb().

    If s is NULL, wctomb() returns a non-zero value (if state-dependent
    encoding is used) or a zero value (if state-dependent encoding is not used).
    If s is not NULL, wctomb() returns 0 (if wchar is zero), the number of
    bytes comprising the multibyte character stored to s (if conversion is
    successful), or -1 (if wchar could not be converted).
*/

#define __INTERNAL_DEFS
#include "libc-alias.h"
#include <sys/locale.h>
#include <stdlib.h>

int _STD(wctomb) (char *s, wchar_t wchar)
{
  UniChar *ucs = &wchar;
  size_t nonid, ni = 1, no = MB_CUR_MAX;

  if (!s)
    return 0;               /* No state dependency */

  if (UniUconvFromUcs (__locale_ctype.uconv, &ucs, &ni, (void **)&s, &no, &nonid))
    return -1;

  return MB_CUR_MAX - no;
}
