/* $Id: weakld.h 485 2003-07-30 18:10:01Z bird $
 *
 * Weak Pre-Linker.
 *
 * Copyright (c) 2003 InnoTek Systemberatung GmbH
 * Author: knut st. osmundsen <bird-srcspam@anduin.net>
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with This program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#ifndef __weak_h__
#define __weak_h__

/*******************************************************************************
*   Structures and Typedefs                                                    *
*******************************************************************************/
struct wld;
typedef struct wld * PWLD;
 
/** wld_create() flags. */
enum wld_create_flags
{
    /** Verbose */
    WLDC_VERBOSE        = 1,    
    /** Skip extended dictionary of libraries. */
    WLDC_NO_EXTENDED_DICTIONARY_SEARCH = 2,    
};


/*******************************************************************************
*   Functions                                                                  *
*******************************************************************************/
PWLD    wld_create(int fFlags);
int     wld_add_object(PWLD pWld, FILE *phFile, const char *pszName);
int     wld_add_deffile(PWLD pWld, FILE *phFile, const char *pszName);
int     wld_add_library(PWLD pWld, FILE *phFile, const char *pszName);
int     wld_generate_weakobj(PWLD pwld, char *pszName);
int     wld_destroy(PWLD pWld);

#endif 
