/* emx.c: Functions for emx as target system.

Written by Eberhard Mattes, based on i386.c.
r=bird: Shouldn't Andy be in here too?

This file is part of GNU CC.

GNU CC is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

GNU CC is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU CC; see the file COPYING.  If not, write to
the Free Software Foundation, 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */

#include "config.h"
#include "system.h"
#include "rtl.h"
#include "regs.h"
#include "hard-reg-set.h"
#include "output.h"
#include "tree.h"
#include "toplev.h"
#include "flags.h"

/* The size of the target's pointer type.  */
#ifndef PTR_SIZE
#define PTR_SIZE (POINTER_SIZE / BITS_PER_UNIT)
#endif

extern int ix86_return_pops_args (tree fundecl, tree funtype, int size);

tree ix86_handle_optlink_attribute (tree *node, tree name, tree args,
  int flags, bool *no_add_attrs)
{
  (void)args; (void)flags;
  if (TREE_CODE (*node) != FUNCTION_TYPE
      && TREE_CODE (*node) != METHOD_TYPE
      && TREE_CODE (*node) != FIELD_DECL
      && TREE_CODE (*node) != TYPE_DECL)
    {
      warning ("`%s' attribute only applies to functions",
	       IDENTIFIER_POINTER (name));
      *no_add_attrs = true;
    }

  return NULL_TREE;
}

/* Value is the number of bytes of arguments automatically
   popped when returning from a subroutine call.
   FUNDECL is the declaration node of the function (as a tree),
   FUNTYPE is the data type of the function (as a tree),
   or for a library call it is an identifier node for the subroutine name.
   SIZE is the number of bytes of arguments passed on the stack.

   On the 80386, the RTD insn may be used to pop them if the number
   of args is fixed, but if the number is variable then the caller
   must pop them all.  RTD can't be used for library calls now
   because the library is compiled with the Unix compiler.
   Use of RTD is a selectable option, since it is incompatible with
   standard Unix calling sequences.  If the option is not selected,
   the caller must always pop the args.

   The attribute stdcall is equivalent to RTD on a per module basis.  */

int
emx_return_pops_args (fundecl, funtype, size)
     tree fundecl;
     tree funtype;
     int size;
{
  return ix86_return_pops_args (fundecl, funtype, size);
#if 0
  int rtd = TARGET_RTD && (!fundecl || TREE_CODE (fundecl) != IDENTIFIER_NODE);

    /* Cdecl functions override -mrtd, and never pop the stack */
  if (!lookup_attribute ("cdecl", TYPE_ATTRIBUTES (funtype))
   && !lookup_attribute ("system", TYPE_ATTRIBUTES (funtype)))
  {
    /* Stdcall functions will pop the stack if not variable args */
    if (lookup_attribute ("stdcall", TYPE_ATTRIBUTES (funtype)))
      rtd = 1;

    /* `optlink' functions taking a variable number of arguments
       should also pop the stack, but that's not implemented.
       We treat `optlink' functions taking a variable number of
       arguments like `system' functions.  */
    if (lookup_attribute ("regparm", TYPE_ATTRIBUTES (funtype)))
      rtd = 1;

    if (rtd
        && (TYPE_ARG_TYPES (funtype) == NULL_TREE
	    || (TREE_VALUE (tree_last (TYPE_ARG_TYPES (funtype))) == void_type_node)))
      return size;
  }

  /* Lose any fake structure return argument */
  /* @@@ This makes the generated code incompatible with that generated
   * by 2.7.2. I think this belongs in the if (rtd) ... case. Any ideas? */
  if (aggregate_value_p (TREE_TYPE (funtype)))
    return GET_MODE_SIZE (Pmode);

  return 0;
#endif
}

void
emx_eh_frame_section ()
{
/*
  tree label = get_file_function_name ('F');
  The __ehInit undefined external here is to drag __ehInit/__ehInitDLL into
  the linking so DLLs are initiated correctly. (#577)
*/
  data_section ();
  ASM_OUTPUT_ALIGN (asm_out_file, floor_log2 (PTR_SIZE));
  fprintf (asm_out_file,
           "\t.stabs\t\"___eh_frame__\",24,0,0,Lframe1\n" /* N_SETD */
           "\t.stabs\t\"___ehInit\",1,0,0,0\n");          /* N_UNDEF | N_EXT */
}

/* Add a __POST$xxx label before epilogue if -mepilogue specified */
void emx_output_function_begin_epilogue (FILE *f)
{
  if (TARGET_EPILOGUE && TREE_PUBLIC (current_function_decl))
  {
    const char *func_label = IDENTIFIER_POINTER (DECL_ASSEMBLER_NAME (current_function_decl));
    char *lbl = alloca (strlen (func_label) + 8);
    strcpy (lbl, "__POST$");
    strcat (lbl, func_label);
    ASM_OUTPUT_LABEL (f, lbl);
  }
}

/* Return string which is the former assembler name modified with a
   suffix consisting of an atsign (@) followed by the number of bytes of
   arguments */

const char *
gen_stdcall_suffix (tree decl)
{
  int total = 0;
  /* ??? This probably should use XSTR (XEXP (DECL_RTL (decl), 0), 0) instead
     of DECL_ASSEMBLER_NAME.  */
  const char *asmname = IDENTIFIER_POINTER (DECL_ASSEMBLER_NAME (decl));
  char *newsym;

  if (TYPE_ARG_TYPES (TREE_TYPE (decl)))
    if (TREE_VALUE (tree_last (TYPE_ARG_TYPES (TREE_TYPE (decl))))
        == void_type_node)
      {
	tree formal_type = TYPE_ARG_TYPES (TREE_TYPE (decl));

	while (TREE_VALUE (formal_type) != void_type_node)
	  {
	    int parm_size
	      = TREE_INT_CST_LOW (TYPE_SIZE (TREE_VALUE (formal_type)));
	    /* Must round up to include padding.  This is done the same
	       way as in store_one_arg.  */
	    parm_size = ((parm_size + PARM_BOUNDARY - 1)
			 / PARM_BOUNDARY * PARM_BOUNDARY);
	    total += parm_size;
	    formal_type = TREE_CHAIN (formal_type);
	  }
      }

  newsym = xmalloc (strlen (asmname) + 10);
  sprintf (newsym, "%s@%d", asmname, total/BITS_PER_UNIT);
  return IDENTIFIER_POINTER (get_identifier (newsym));
}

const char *
emx_remove_underscore (tree decl)
{
  /* ??? This probably should use XSTR (XEXP (DECL_RTL (decl), 0), 0) instead
     of DECL_ASSEMBLER_NAME.  */
  const char *asmname = IDENTIFIER_POINTER (DECL_ASSEMBLER_NAME (decl));
  char *newsym = xmalloc (strlen (asmname) + 2);
  sprintf (newsym, "\b%s", asmname);
  return IDENTIFIER_POINTER (get_identifier (newsym));
}

/* Cover function to implement ENCODE_SECTION_INFO.  */

void
emx_encode_section_info (tree decl)
{
  /* This bit is copied from i386.h.  */
  if (optimize > 0 && TREE_CONSTANT (decl)
      && (!flag_writable_strings || TREE_CODE (decl) != STRING_CST))
    {
      rtx rtl = (TREE_CODE_CLASS (TREE_CODE (decl)) != 'd'
                 ? TREE_CST_RTL (decl) : DECL_RTL (decl));
      SYMBOL_REF_FLAG (XEXP (rtl, 0)) = 1;
    }

  if (TREE_CODE (decl) == FUNCTION_DECL)
    {
      if (lookup_attribute ("stdcall",
          		  TYPE_ATTRIBUTES (TREE_TYPE (decl))))
        XEXP (DECL_RTL (decl), 0) =
          gen_rtx (SYMBOL_REF, Pmode, gen_stdcall_suffix (decl));
      else if (lookup_attribute ("optlink",
                                 TYPE_ATTRIBUTES (TREE_TYPE (decl)))
               || lookup_attribute ("system",
                                    TYPE_ATTRIBUTES (TREE_TYPE (decl))))
        XEXP (DECL_RTL (decl), 0) =
          gen_rtx (SYMBOL_REF, Pmode, emx_remove_underscore (decl));
    }
}
