/* Called at startup to register frame unwind info tables and at shutdown
   to deregister FUI tables. Used when frame unwinding info is enabled
   (C++ without --fno-exceptions and without -fsjlj-exceptions). */

extern int __eh_frame__;
extern void __register_frame_table (void *begin);
extern void __deregister_frame (void *begin);
extern int  atexit(void (*f)());


/** Exception handler stuff init indicator. 0 means not inited, 1 means inited. */
static int inited;

extern void __ehTermDLL (void);
extern void __ehInitDLL (void);
extern void __ehInit (void);
static void __ehTerm (void);


/**
 * Inits exception handler stuff.
 * Intended external caller is _DLL_InitTerm.
 */
void __ehInitDLL (void)
{
  if (!inited)
    {
      int *ptr = &__eh_frame__;
      inited = 1;
      __register_frame_table (&ptr [*ptr == -2 ? 1 : 2]);
    }
}

/**
 * Terminates exception handler stuff.
 * Intended external caller is _DLL_InitTerm.
 */
void __ehTermDLL (void)
{
  if (inited)
    {
      int *ptr = &__eh_frame__;
      inited = 0;
      __deregister_frame (&ptr [*ptr == -2 ? 1 : 2]);
    }
}


/**
 * atexit() procedure used pto terminate exception stuff in programs.
 * Registered by __ehInit.
 */
static void __ehTerm (void)
{
  __ehTermDLL();
}

/** 
 * Init exception handler stuff for a program.
 * Intended external caller is GCC generated main() code.
 */
void __ehInit (void)
{
  if (!inited)
    {
      atexit (__ehTerm);
      __ehInitDLL();
    }
}

