/*  */
#include <emx/startup.h>
extern int _CRT_init (void);
extern void __ctordtorInit (void);
extern void __ctordtorTerm (void);
extern void __ehInitDLL (void);
#pragma weak __ehInitDLL
extern void __ehTermDLL (void);
#pragma weak __ehTermDLL

/**
 * This is the typical DLL startup code. __ehInitDLL and __ehTermDLL is called
 * are for exception handler stuff in gcc, the two functions will be linked if 
 * there is exception handler info in the module. (Btw. if these calls wasn't 
 * made we would fail to catch exceptions in C++ code.)
 * @returns 1 on success.
 * @returns 0 on failure.
 * @param   hmod    Handle of this DLL.
 * @param   flag    0 init.
 *                  1 term.
 * @remark  This function is called from dll0.asm.
 */
unsigned _System _DLL_InitTerm (unsigned hmod, unsigned flag)
{
  switch (flag)
  {
    case 0:
      if (_CRT_init () != 0)
        break;
      if (__ehInitDLL)
        __ehInitDLL ();
      __ctordtorInit ();
      return 1;
    case 1:
      __ctordtorTerm ();
      if (__ehTermDLL)
        __ehTermDLL ();
      return 1;
  }
  return 0;
}
