/* $Id: bsdselect.c 388 2003-07-15 18:49:19Z bird $
 *
 * Wrapper for bsdselect() in BSD 4.4 mode.
 *
 * Copyright (c) 2003 InnoTek Systemberatung GmbH
 * Author: knut st. osmundsen <bird@anduin.net>
 *
 * All Rights Reserved
 *
 */
#include <stdlib.h>
#include <alloca.h>
#include <sys/types.h>
#include <sys/select.h>


#define V5_FD_SETSIZE      64

#pragma pack(4)
typedef struct v5_fd_set {
        u_short fd_count;               /* how many are SET? */
        int     fd_array[V5_FD_SETSIZE];/* an array of SOCKETs */
} v5_fd_set;
#pragma pack()

#define V5_FD_SET(fd, set) do { \
    if (((v5_fd_set *)(set))->fd_count < V5_FD_SETSIZE) \
        ((v5_fd_set *)(set))->fd_array[((v5_fd_set *)(set))->fd_count++]=fd;\
} while(0)

int _System v5_bsdselect(int, struct v5_fd_set *, struct v5_fd_set *, struct v5_fd_set *, struct timeval *);


static inline void convert(int c, const struct fd_set *pFrom, struct v5_fd_set *pTo)
{
    int i = 0;

    memset(pTo, 0, sizeof(struct v5_fd_set));
    for (i = 0; i < c; i++)
    {
        if (FD_ISSET(i, pFrom))
            V5_FD_SET(i, pTo);
    }
    /** @todo: check for overflow and return appropriate error code... */
}


/**
 * This wrapper is required to work around a new ushort field someone
 * at IBM added to speed up the macros accessing the select structure.
 * @remark Only BSD 4.4 mode.
 */
int _System bsdselect(int nfds, struct fd_set *readfds, struct fd_set *writefds,
                      struct fd_set *excptfds, struct timeval *timeout)
{
    int     rc;
    struct v5_fd_set *pv5_readfds  = NULL;
    struct v5_fd_set *pv5_writefds = NULL;
    struct v5_fd_set *pv5_excptfds = NULL;
    int     cfds = nfds <= 0 ? FD_SETSIZE : nfds;

    if (readfds)
    {
        pv5_readfds = alloca(sizeof(struct v5_fd_set));
        convert(cfds, readfds, pv5_readfds);
    }

    if (writefds)
    {
        pv5_writefds = alloca(sizeof(struct v5_fd_set));
        convert(cfds, writefds, pv5_writefds);
    }

    if (excptfds)
    {
        pv5_excptfds = alloca(sizeof(struct v5_fd_set));
        convert(cfds, excptfds, pv5_excptfds);
    }

    rc = v5_bsdselect(nfds, pv5_readfds, pv5_writefds, pv5_excptfds, timeout);

    return rc;
}


