/* $Id: sock_errno.c 387 2003-07-15 18:49:02Z bird $
 *
 * Wrapper for sock_errno return values - both modes.
 *
 * Copyright (c) 2003 InnoTek Systemberatung GmbH
 * Author: knut st. osmundsen <bird@anduin.net>
 *
 * All Rights Reserved
 *
 */

#include <sys/types.h>
#include <sys/socket.h>

/**
 * Get the last socket error number.
 * This wrapper is required to get match our error defines in errno.h. OS/2
 * tcpip uses the FreeBSD / M$C errno.h values with an offset of 10000.
 *
 * @returns libc compatible errno for last socket operation.
 */
int _System sock_errno(void)
{
    /* get the OS/2 error. */
    int err = os2_sock_errno();
    if (err > 10000 && err < 11000)
        err -= 10000;
    return err;
}

