/* $Id: statshdr.cmd 356 2003-07-11 12:28:06Z bird $
 *
 * Check all the headers if they can be included alone.
 * There is an exclusion list to skip those that requires company.
 *
 * InnoTek Systemberatung GmbH confidential
 *
 * Copyright (c) 2003 InnoTek Systemberatung GmbH
 * Author: knut st. osmundsen <bird@anduin.net>
 *
 * All Rights Reserved
 *
 */

parse arg sInclude sOther
sFile = '';
if (sInclude = '') then
do
    say 'syntax: statshdrs <includedir>';
    exit 8;
end

/*
 * Normalize input.
 */
asFiles.0 = 0;
rc = SysFileTree(sInclude, 'asFiles', 'OD');
if (asFiles.0 <> 1) then
do
    say 'error!: failed to find '''sInclude'''.';
    exit 8;
end
sInclude = asFiles.1;


/*
 * Exclude list.
 */
i = 1;
asExcludes.i = 'objc\encoding.h'; i=i+1;
asExcludes.i = 'objc\hash.h'; i=i+1;
asExcludes.i = 'objc\NXConstS.h'; i=i+1;
asExcludes.i = 'objc\objc-api.h'; i=i+1;
asExcludes.i = 'objc\objc-lis.h'; i=i+1;
asExcludes.i = 'objc\objc.h'; i=i+1;
asExcludes.i = 'objc\Object.h'; i=i+1;
asExcludes.i = 'objc\Protocol.h'; i=i+1;
asExcludes.i = 'objc\sarray.h'; i=i+1;
asExcludes.i = 'objc\thr.h'; i=i+1;
asExcludes.i = 'objc\typedstr.h'; i=i+1;
asExcludes.0 = i - 1;


/*
 * Get files.
 */
asFiles.0 = 0;
if (sFile <> '') then
do
    rc = SysFileTree(sFile, 'asFiles', 'OSF');
    if (asFiles.0 = 0) then
        rc = SysFileTree(sInclude'\'sFile, 'asFiles', 'OSF');
end
else
    rc = SysFileTree(sInclude'\*.h', 'asFiles', 'OSF');
if (rc <> 0) then
do
    say 'error! SysFileTree failed with rc='rc'!';
    exit 8;
end
say 'info: Headers to test 'asFiles.0'...';


/*
 * Do testing.
 */
sOut = 'STDOUT';
call lineout sOut, 'Header Statistics'
call lineout sOut, '-----------------'
call lineout sOut, ''
call lineout sOut, left('File', 24)||X2C('09')||left('Level', 16);
call lineout sOut, left('-', 24, '-')||X2C('09')||left('-', 16,'-');
do i = 1 to asFiles.0
    call statfile sOut, sInclude, asFiles.i;
end
call lineout sOut;

exit(asFailed.0);



/**
 * Test one file.
 * @returns 0
 * @param   sDir    Include directory (for the -I option and for basing sFile).
 * @param   sFile   The include file to test, full path.
 */
statfile: procedure expose asExcludes.
parse arg sOut, sDir, sFile
    sName = substr(sFile, length(sDir) + 2);
    sLevel = '--';
    sRemark = '';
    sChanged = '';
    if (isExcluded(sName)) then
    do
        say 'info: skipping 'sName'...';
        return 0;
    end

    iLine = 1;
    do while (lines(sFile) & iLine < 200)
        sLine = strip(linein(sFile));
        if (left(sLine, 1) = '*' & pos('@@', sLine) > 0) then
        do
            iPos = pos('@@', sLine);
            sWord = word(substr(sLine, iPos + 2), 1);
            if (sWord == 'level') then
                sLevel = strip(substr(sLine, iPos + 2 + 5));
            else if (sWord == 'remark') then
                sRemark = strip(substr(sLine, iPos + 2 + 6));
            else if (sWord == 'changed') then
                sChanged = strip(substr(sLine, iPos + 2 + 7));
        end
        iLine = iLine + 1;
    end

    call lineout sOut, left(sName, 24)||X2C('09')||left(sLevel, 16);
    if (sRemark <> '') then
        call lineout sOut, X2C('09')'remark:  '||sRemark;
    if (sChanged <> '') then
        call lineout sOut, X2C('09')'changes by '||sChanged
return 0;


/**
 * Check if sFile is excluded from testing.
 */
isExcluded: procedure expose asExcludes.
parse arg sFile
    do i = 1 to asExcludes.0
        if (sFile = asExcludes.i) then
            return 1;
    end
return 0;

