# portage: Constants
# Copyright 1998-2004 Gentoo Foundation
# Distributed under the terms of the GNU General Public License v2
# $Id: portage_const.py 5493 2007-01-09 02:18:21Z antarus $


# ===========================================================================
# START OF CONSTANTS -- START OF CONSTANTS -- START OF CONSTANTS -- START OF
# ===========================================================================

import os

# bird: ROOT_PATH ends with a trailing slash.
#       EXE_SUFF is .exe on OS/2 and NT systems.
#       PATH_SEP is ';' on OS/2 and NT systems.
import sys
ROOT_PATH               = "/"
EXE_SUFF                = ""
PATH_SEP                = ":"
if sys.platform == "os2knix" or sys.platform == "ntknix":
	ROOT_PATH           = "/@unixroot/"
	EXE_SUFF            = ".exe"
	PATH_SEP            = ";"

VDB_PATH                = "var/db/pkg"
PRIVATE_PATH            = "var/lib/portage"
CACHE_PATH              = ROOT_PATH+"var/cache/edb"
DEPCACHE_PATH           = CACHE_PATH+"/dep"

USER_CONFIG_PATH        = "/etc/portage"
MODULES_FILE_PATH       = USER_CONFIG_PATH+"/modules"
CUSTOM_PROFILE_PATH     = USER_CONFIG_PATH+"/profile"

#PORTAGE_BASE_PATH       = "/usr/lib/portage"
PORTAGE_BASE_PATH       = os.path.join(os.sep, os.sep.join(__file__.split(os.sep)[:-2]))
PORTAGE_BIN_PATH        = PORTAGE_BASE_PATH+"/bin"
PORTAGE_PYM_PATH        = PORTAGE_BASE_PATH+"/pym"
PROFILE_PATH            = "/etc/make.profile"
LOCALE_DATA_PATH        = PORTAGE_BASE_PATH+"/locale"

EBUILD_SH_BINARY        = PORTAGE_BIN_PATH+"/ebuild.sh"
MISC_SH_BINARY          = PORTAGE_BIN_PATH + "/misc-functions.sh"
SANDBOX_BINARY          = ROOT_PATH+"usr/bin/sandbox"+EXE_SUFF
BASH_BINARY             = ROOT_PATH+"bin/bash"+EXE_SUFF
MOVE_BINARY             = ROOT_PATH+"bin/mv"+EXE_SUFF
PRELINK_BINARY          = ROOT_PATH+"usr/sbin/prelink"+EXE_SUFF

WORLD_FILE              = PRIVATE_PATH + "/world"
MAKE_CONF_FILE          = "/etc/make.conf"
MAKE_DEFAULTS_FILE      = PROFILE_PATH + "/make.defaults"
DEPRECATED_PROFILE_FILE = PROFILE_PATH+"/deprecated"
USER_VIRTUALS_FILE      = USER_CONFIG_PATH+"/virtuals"
EBUILD_SH_ENV_FILE      = USER_CONFIG_PATH+"/bashrc"
INVALID_ENV_FILE        = ROOT_PATH+"etc/spork/is/not/valid/profile.env"
CUSTOM_MIRRORS_FILE     = USER_CONFIG_PATH+"/mirrors"
CONFIG_MEMORY_FILE      = PRIVATE_PATH + "/config"
COLOR_MAP_FILE          = USER_CONFIG_PATH + "/color.map"

INCREMENTALS=["USE","USE_EXPAND","USE_EXPAND_HIDDEN","FEATURES","ACCEPT_KEYWORDS","ACCEPT_LICENSE","CONFIG_PROTECT_MASK","CONFIG_PROTECT","PRELINK_PATH","PRELINK_PATH_MASK"]
EBUILD_PHASES           = ["setup", "unpack", "compile", "test", "install",
                          "preinst", "postinst", "prerm", "postrm", "other"]

EAPI = 0

HASHING_BLOCKSIZE        = 32768
MANIFEST1_HASH_FUNCTIONS = ["MD5","SHA256","RMD160"]
MANIFEST2_HASH_FUNCTIONS = ["SHA1","SHA256","RMD160"]
MANIFEST2_REQUIRED_HASH = "SHA1"

MANIFEST2_IDENTIFIERS = ["AUX","MISC","DIST","EBUILD"]

# ===========================================================================
# END OF CONSTANTS -- END OF CONSTANTS -- END OF CONSTANTS -- END OF CONSTANT
# ===========================================================================
