/* $Id: checkhdrs.cmd 337 2003-07-10 12:30:30Z bird $
 *
 * Check all the headers if they can be included alone.
 * There is an exclusion list to skip those that requires company.
 *
 * InnoTek Systemberatung GmbH confidential
 *
 * Copyright (c) 2003 InnoTek Systemberatung GmbH
 * Author: knut st. osmundsen <bird@anduin.net>
 *
 * All Rights Reserved
 *
 */

parse arg sInclude sOther
if (sInclude = '') then
do
    say 'syntax: checkhdrs <includedir>';
    exit 8;
end

/*
 * Normalize input.
 */
asFiles.0 = 0;
rc = SysFileTree(sInclude, 'asFiles', 'OD');
if (asFiles.0 <> 1) then
do
    say 'error!: failed to find '''sInclude'''.';
    exit 8;
end
sInclude = asFiles.1;


/*
 * Exclude list.
 */
i = 1;
asExcludes.i = ''; i=i+1;
asExcludes.0 = i - 1;


/*
 * Get files.
 */
asFiles.0 = 0;
rc = SysFileTree(sInclude'\*.h', 'asFiles', 'OSF');
if (rc <> 0) then
do
    say 'error! SysFileTree failed with rc='rc'!';
    exit 8;
end
say 'info: Headers to test 'asFiles.0'...';


/*
 * Do testing.
 */
asFailed.0 = 0;
do i = 1 to asFiles.0
    sName = substr(asFiles.i, length(sInclude) + 2);
    say 'info: testing 'sName'....';
    sTmp = '.\tmpfile.cpp';
    sTmpS = '.\tmpfile.s';
    call SysFileDelete sTmp;
    call lineout sTmp, '#include <'sName'>';
    call lineout sTmp, 'int main() {return 0;}';
    call lineout sTmp
    Address CMD 'gcc -S -I'sInclude sTmp;
    if (rc <> 0) then
    do
        j = asFailed.0 + 1;
        asFailed.j = sName;
        asFailed.0 = j;
    end
    call SysFileDelete sTmp;
    call SysFileDelete sTmpS;
end

if (asFailed.0 > 0) then
do
    say 'The following files failed:'
    do i = 1 to asFailed.0
        say '  'asFailed.i;
    end
end

exit(asFailed.0);
