/* sys/types.h (emx+gcc) */

#ifndef _SYS_TYPES_H
#define _SYS_TYPES_H

/* freebsd/toolkit compatibility */
#include <sys/cdefs.h>
#include <sys/inttypes.h> /* includes machine/ansi.h */
#include <machine/types.h>
#include <machine/endian.h>

#if !defined (_SIZE_T)
#define _SIZE_T
typedef unsigned long size_t;
#undef  _BSD_SIZE_T_
#endif

#if !defined (_SSIZE_T)
#define _SSIZE_T
typedef int ssize_t;
#undef  _BSD_SSIZE_T_
#endif

#if !defined (_TIME_T)
#define _TIME_T
typedef unsigned long time_t;
#undef  _BSD_TIME_T_
#endif

#if !defined (_INO_T)
#define _INO_T
typedef int ino_t;
#undef  _BSD_INO_T_
#endif

#if !defined (_DEV_T)
#define _DEV_T
typedef int dev_t;
#undef  _BSD_DEV_T_
#endif

#if !defined (_OFF_T)
#define _OFF_T
typedef long off_t;
#undef  _BSD_OFF_T_
#endif

#if !defined (_MODE_T)
#define _MODE_T
typedef int mode_t;
#undef  _BSD_MODE_T_
#endif

#if !defined (_NLINK_T)
#define _NLINK_T
typedef int nlink_t;
#undef  _BSD_NLINK_T_
#endif

#if !defined (_UID_T)
#define _UID_T
typedef int uid_t;
#undef  _BSD_UID_T_
#endif

#if !defined (_PID_T)
#define _PID_T
typedef int pid_t;
#undef  _BSD_PID_T_
#endif

#if !defined (_GID_T)
#define _GID_T
typedef int gid_t;
#undef  _BSD_GID_T_
#endif

#if !defined (_POSIX_SOURCE)

#if !defined (FD_SETSIZE)
#define	FD_SETSIZE 256
#elif FD_SETSIZE < 256
#error FD_SETSIZE must be at least 256
#endif

#ifndef _howmany
#define	_howmany(a,b)       (((a) + ((b) - 1)) / (b))
#endif
#if defined(TCPV40HDRS) && !defined(howmany)
#define	howmany(a,b)        (((a) + ((b) - 1)) / (b))
#endif

#if !defined (_FD_SET_T)
#define _FD_SET_T
/** The base type for the select file descriptor bitmap. */
typedef unsigned long   __fd_mask;
/** Number of bits in a byte. */
#define NBBY        8
/** Number of bits in a byte. */
#define _NFDBITS    (sizeof(__fd_mask) * 8)	/* bits per mask */
/** Select set. */
typedef struct fd_set
{
    __fd_mask   __fds_bits[_howmany(FD_SETSIZE, _NFDBITS)];
} fd_set;

#if defined(__BSD_VISIBLE) || defined(TCPV40HDRS)
typedef __fd_mask   fd_mask;
#define fds_bits    __fds_bits
#define NFDBITS     _NFDBITS
#endif

#endif

#ifndef FD_SET
/** Set a bit in the select file descriptor bitmap. */
#define	FD_SET(n,s)    ((s)->__fds_bits[(n)/_NFDBITS] |=  (1L << ((n) & (_NFDBITS - 1))))
/** Clear a bit in the select file descriptor bitmap. */
#define	FD_CLR(n,s)    ((s)->__fds_bits[(n)/_NFDBITS] &= ~(1L << ((n) & (_NFDBITS - 1))))
/** Test if a bit in the select file descriptor bitmap is set. */
#define	FD_ISSET(n,s)  ((s)->__fds_bits[(n)/_NFDBITS] &   (1L << ((n) & (_NFDBITS - 1))))
/** Initialize the select file descriptor bitmap clearing all bits. */
#define FD_ZERO(s)     (void)memset(s, 0, sizeof(*(s)))
#if __BSD_VISIBLE
/** Copy a select file descriptor bitmap. */
#define	FD_COPY(src,trg) (void)(*(trg) = *(src))
#endif
#endif /* !FD_SET */

#endif /* !_POSIX_SOURCE */

#if !defined (_POSIX_SOURCE)

typedef	unsigned char u_char;
typedef	unsigned short u_short;
typedef	unsigned u_int;
typedef	unsigned long u_long;
typedef char *caddr_t;

/* toolkit pollution */
#ifdef __32BIT__
typedef int             long_int;       /* 32-bit compilers */
#else
typedef long int        long_int;       /* 16-bit compilers */
#endif

#endif /* not _POSIX_SOURCE */

typedef __uint8_t	u_int8_t;
typedef __uint16_t	u_int16_t;
typedef __uint32_t	u_int32_t;
typedef __uint64_t	u_int64_t;

#endif /* not _SYS_TYPES_H */
