/* $Id: $ */
/** @file
 *
 * kLIBC - sys/timeb.h.
 *
 * Copyright (c) 2006 knut st. osmundsen <bird-srcspam@anduin.net>
 *
 *
 * This file is part of kLIBC.
 *
 * kLIBC is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * kLIBC is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with kLIBC; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#ifndef _SYS_TIMEB_H
#define _SYS_TIMEB_H

#include <sys/cdefs.h>
#include <sys/_types.h>

__BEGIN_DECLS

#if !defined(_TIME_T_DECLARED) && !defined(_TIME_T) /* bird: EMX */
typedef	__time_t	time_t;
#define	_TIME_T_DECLARED
#define _TIME_T                         /* bird: EMX */
#endif

struct timeb
{
    time_t      time;
    unsigned    millitm;
    int         timezone;
    int         dstflag;
};

void ftime(struct timeb *);
void _ftime(struct timeb *);

__END_DECLS

#endif

