/* Configuration for an i386 running emx (target). */

/* Use #ifdef EMX for issues needed by EMX target */
/* Use #ifdef __EMX__ for issues needed on a EMX host */
/* Note that the cross-compiler is untested */
#define EMX

/* We do want to add an underscore to the front of each user symbol. */
#define YES_UNDERSCORES

#include <stdio.h>		/* for FILE* */
#include "i386/gstabs.h"	/* GAS stabs */
#include "aoutos.h"		/* constructors/destructors/garbage collectors */

/* Some additional system-dependent includes... */
#include <sys/emxload.h>
#include <sys/uflags.h>

/* EMX does not define strcasecmp but has stricmp instead */
#define strcasecmp stricmp

/* Define an additional switch -m(no-)probe for backward compatibility */
/* Also define the -m(no-)epilogue switch */

#define MASK_EPILOGUE		0x40000000      /* Use FUNCTION_EPILOGUE */

#undef SUBTARGET_SWITCHES
#define SUBTARGET_SWITCHES						      \
  { "probe", MASK_STACK_PROBE, N_("Do stack probing")},			      \
  { "no-probe", -MASK_STACK_PROBE, N_("Don't do stack probing")},	      \
  { "epilogue", MASK_EPILOGUE, N_("Generate prologue/epilogue labels")},      \
  { "no-epilogue", -MASK_EPILOGUE, N_("Don't generate prologue/epilogue labels") },

/* By default, target has a 80387, uses IEEE compatible arithmetic,
   and returns float values in the 387 and needs stack probes */
#undef TARGET_SUBTARGET_DEFAULT
#define TARGET_SUBTARGET_DEFAULT \
   (MASK_80387 | MASK_IEEE_FP | MASK_FLOAT_RETURNS | MASK_STACK_PROBE)

/* Use FUNCTION_EPILOGUE */
#define TARGET_EPILOGUE (target_flags & MASK_EPILOGUE)

/* OS/2 executables ends with .exe */
#define TARGET_EXECUTABLE_SUFFIX ".exe"
#define NO_FORCE_EXEOBJ_SUFFIX

/* The system headers are C++-aware. */
#define NO_IMPLICIT_EXTERN_C

/* Don't provide default values for __CTOR_LIST__ and __DTOR_LIST__ in libgcc */
#define CTOR_LISTS_DEFINED_EXTERNALLY

/* Enable parsing of #pragma pack(push,<n>) and #pragma pack(pop).  */
#define HANDLE_PRAGMA_PACK_PUSH_POP 1

/* Enable #pragma weak (in the limited way OS/2 supports them, however) */
#define HANDLE_PRAGMA_WEAK 1

/* Use `#' instead of `/' as assembler comments */
#undef ASM_COMMENT_START
#define ASM_COMMENT_START "#"
#undef ASM_APP_ON
#define ASM_APP_ON "#APP\n"
#undef ASM_APP_OFF
#define ASM_APP_OFF "#NO_APP\n"

/* Support for C++ templates.  */
#undef MAKE_DECL_ONE_ONLY
#define MAKE_DECL_ONE_ONLY(DECL) (DECL_WEAK (DECL) = 1)

/* This is how we tell the assembler that a symbol is weak.  */
#define ASM_WEAKEN_LABEL(FILE, NAME) 	\
  do					\
    {					\
      fputs ("\t.weak\t", (FILE));	\
      assemble_name ((FILE), (NAME)); 	\
      fputc ('\n', (FILE));		\
    }					\
  while (0)

/* We support kind of weak symbols */
#define SUPPORTS_WEAK 1

/* Define this macro if in some cases global symbols from one translation
   unit may not be bound to undefined symbols in another translation unit
   without user intervention.  For instance, under Microsoft Windows
   symbols must be explicitly imported from shared libraries (DLLs).  */
#define MULTIPLE_SYMBOL_SPACES 1

/* We want DWARF2 frame unwind info for exception handling */
#define DWARF2_UNWIND_INFO 1

/* The function to call after __main in the case program uses exceptions */
#define NAME__EH_INIT "__ehInit"

/* This macros will stick a label to exception table for current file,
 * and also will put it in a 'ctor/dtor' - like list (using .stabs - this uses
 * same technique used in aoutos.h) which ld will collect into a single table
 * and then __ctordtorInit will use this table to make a call to
 * __register_frame_table
 */
#define TARGET_ASM_EH_FRAME_SECTION emx_eh_frame_section
extern void emx_eh_frame_section (void);

/* Put exception tables into .data section */
#define TARGET_ASM_EXCEPTION_SECTION data_section

/* Terminate DWARF frame unwind info with a closing zero */
#define DWARF2_FRAMEINFO_NULL_TERMINATED 1

/* Generate stack probes for allocations bigger than */
#define CHECK_STACK_LIMIT 0x1000

/* Define the type for size_t */
#define SIZE_TYPE		"long unsigned int"
#define PTRDIFF_TYPE		"long int"

/* wchar_t is unsigned short. */
#define WCHAR_UNSIGNED		1
#define WCHAR_TYPE              "short unsigned int"
#define WCHAR_TYPE_SIZE         16

/* For Win32 ABI compatibility */
#define DEFAULT_PCC_STRUCT_RETURN 0

/* No data type wants to be aligned rounder than this.  */
#define BIGGEST_ALIGNMENT 128

/* Win32 complier aligns internal doubles in structures on dword boundaries.
   We need to emulate this behaviour for easier porting. */
#define BIGGEST_FIELD_ALIGNMENT 64

/* If bit field type is int, don't let it cross an int,
   and give entire struct the alignment of an int.  */
/* Required on the 386 since it doesn't have bitfield insns.  */
#define PCC_BITFIELD_TYPE_MATTERS 1

/* Don't continue symbols.  I think all relevant tools can handle
   symbols of arbitrary length.  GAS does not correctly handle
   continued symbols: it sometimes emits another symbol before the
   continuation. */
#define DBX_CONTIN_LENGTH 0

/* If defined, a C expression whose value is a string containing the
   assembler operation to identify the following data as
   uninitialized global data.  If not defined, and neither
   `ASM_OUTPUT_BSS' nor `ASM_OUTPUT_ALIGNED_BSS' are defined,
   uninitialized global data will be output in the data section if
   `-fno-common' is passed, otherwise `ASM_OUTPUT_COMMON' will be
   used.  */
#undef BSS_SECTION_ASM_OP
#define BSS_SECTION_ASM_OP "\t.bss"

/* A C statement (sans semicolon) to output to the stdio stream
   FILE the assembler definition of uninitialized global DECL named
   NAME whose size is SIZE bytes and alignment is ALIGN bytes.
   Try to use asm_output_aligned_bss to implement this macro.  */
#define ASM_OUTPUT_ALIGNED_BSS(FILE, DECL, NAME, SIZE, ALIGN) \
  asm_output_aligned_bss (FILE, DECL, NAME, SIZE, ALIGN)

/* This is how to output an assembler line that says to advance the
   location counter to a multiple of 2**LOG bytes.  */
#undef ASM_OUTPUT_ALIGN
#define ASM_OUTPUT_ALIGN(FILE,LOG)	\
    if ((LOG)!=0) fprintf ((FILE), "\t.align %d\n", LOG)

/*******************************************************************
   The following encodings are used for label names
   depending on their attributes:

   stdcall labels get a suffix consisting of an at-sign '@' and
   the size of parameters in bytes rounded to next multiple of 4.

   optlink labels get a prefix of '\b' (e.g. backspace). This kind of
   means that the symbol name should not be prefixed by an underscore.
*******************************************************************/

/* Define this macro if references to a symbol must be treated
   differently depending on something about the variable or
   function named by the symbol (such as what section it is in). */
#undef ENCODE_SECTION_INFO
#define ENCODE_SECTION_INFO(DECL) emx_encode_section_info (DECL)
extern void emx_encode_section_info PARAMS ((tree));

/* This macro gets just the user-specified name
   out of the string in a SYMBOL_REF.  Discard
   trailing @[NUM] encoded by ENCODE_SECTION_INFO.  */
#undef  STRIP_NAME_ENCODING
#define STRIP_NAME_ENCODING(VAR,SYMBOL_NAME)				\
do {									\
  const char *_p;							\
  const char *_name = SYMBOL_NAME;					\
  if (*_name == '\b') _name++;						\
  for (_p = _name; *_p && *_p != '@'; ++_p)				\
    ;									\
  if (*_p == '@')							\
    {									\
      int _len = _p - _name;						\
      char *_new_name = (char *) alloca (_len + 1);			\
      strncpy (_new_name, _name, _len);					\
      _new_name[_len] = '\0';						\
      (VAR) = _new_name;						\
    }									\
  else									\
    (VAR) = _name;							\
} while (0)

/* Output a reference to a label.  */
#undef ASM_OUTPUT_LABELREF
#define ASM_OUTPUT_LABELREF(STREAM, NAME)  				\
  fprintf (STREAM, "%s%s", *NAME == '\b' ? "" : USER_LABEL_PREFIX,	\
    *NAME == '\b' ? NAME + 1 : NAME)

/* Handle _optlink attributes */
extern tree ix86_handle_optlink_attribute PARAMS ((tree *, tree, tree, int, _Bool *));

/******************************************************************************
 *                       - S - W - I - T - C - H - E - S -
 ******************************************************************************/

/* The -Zstack option takes an argument. */
#define WORD_SWITCH_TAKES_ARG(STR) (DEFAULT_WORD_SWITCH_TAKES_ARG (STR)	\
                                    || !strcmp (STR, "Zstack"))

/* Add a __POST$xxx label before epilogue if -mepilogue specified */
extern void emx_output_function_begin_epilogue (FILE *);
#undef TARGET_ASM_FUNCTION_BEGIN_EPILOGUE
#define TARGET_ASM_FUNCTION_BEGIN_EPILOGUE emx_output_function_begin_epilogue

/* Output assembler code to FILE to increment profiler label # LABELNO
   for profiling a function entry.  */

#undef FUNCTION_PROFILER
#define FUNCTION_PROFILER(FILE, LABELNO)				\
{									\
    fprintf (FILE, "\tcall __mcount\n");				\
}

/* Calling conventions */

extern int emx_return_pops_args PARAMS ((tree, tree, int));
#undef RETURN_POPS_ARGS
#define RETURN_POPS_ARGS(FUNDECL,FUNTYPE,SIZE)				\
    (emx_return_pops_args (FUNDECL, FUNTYPE, SIZE))

/******************************************************************************
 *                             - S - P - E - C - S -
 ******************************************************************************/
#define __EMX__LIBCSPECS
/* Predefine symbols `__32BIT__', `__EMX__', `i386' and __MT__ (not -Zmt). */
#undef CPP_PREDEFINES
#define CPP_PREDEFINES "-D__32BIT__ -D__EMX__ -D__OS2__ -D__i386__ -D__i386 "  \
  "-Dunix -D__MT__ -Asystem=unix -Asystem=posix -Asystem=emx"

#undef CPP_SPEC
#define CPP_SPEC							       \
  "%(cpp_cpu) "								       \
  "%{posix:-D_POSIX_SOURCE} "						       \
  "%{Zmt:} "    							       \
  "%{pg:-D__GPROF__} "							       \
  "%{mepilogue:-D__EPILOGUE__} "					       \
  "%{mprobe|mstack-arg-probe:-D__STACK_PROBE__} "			       \
  "-D__cdecl=__attribute__((__cdecl__)) "				       \
  "-D__stdcall=__attribute__((__stdcall__)) "				       \
  "%{!ansi: "								       \
    "-D_cdecl=__attribute__((__cdecl__)) "				       \
    "-D_stdcall=__attribute__((__stdcall__)) "				       \
    "-D_Cdecl=__attribute__((__cdecl__)) "				       \
    "-D_Optlink=__attribute__((__optlink__)) "				       \
    "-D_System=__attribute__((__system__))}"

/* Pass -s (as -Zstrip) to the assembler. */
#ifdef __EMX__LIBCSPECS
#define ASM_SPEC "--traditional-format %{Zomf} %{s:-Zstrip}"
#else
#define ASM_SPEC "%{Zomf} %{s:-Zstrip}"
#endif

#ifdef __EMX__LIBCSPECS
/* bird: precautions. */
#undef ASM_DEBUG_SPEC
#define ASM_DEBUG_SPEC "%{g*:--gstabs}"
#endif

#ifdef __EMX__LIBCSPECS
#define LINK_SPEC							       \
  "%{Zexe} %{Zstack*} %{Zmap*} %{Zomf:%{Zdll}} "			       \
  "%{!o*:-o %b%{Zdll:.dll}%{!Zdll:%{!Zexe:.exe}}} "			       \
  "%{static:%{Zcrtdll*:%e-static and -Zcrtdll are incompatible}}"	       \
  "%{Zdll:%{Zexe:%e-Zdll and -Zexe are incompatible}}"			       \
  "%{Zsmall-conv:%{Zcrtdll*:%e-Zsmall-conv and -Zcrtdll are incompatible}}"
#else
#define LINK_SPEC							       \
  "%{Zexe} %{Zstack*} %{Zmap*} %{Zomf:%{Zdll}} "			       \
  "%{!o*:-o %b%{Zdll:.dll}%{!Zdll:%{!Zexe:.exe}}} "			       \
  "%{static:%{Zcrtdll*:%e-static and -Zcrtdll are incompatible}}"	       \
  "%{Zdll:%{Zexe:%e-Zdll and -Zexe are incompatible}}"			       \
  "%{Zso:%{!Zsys:%e-Zso requires -Zsys}}"				       \
  "%{Zso:%{!Zdll:%e-Zso requires -Zdll}}"				       \
  "%{Zno-rte:%{!Zdll:%e-Zno-rte requires -Zdll}}"			       \
  "%{Zno-rte:%{!Zomf:%e-Zno-rte requires -Zomf}}"			       \
  "%{Zno-rte:%{Zsys:%e-Zno-rte and -Zsys are incompatible}}"		       \
  "%{Zno-rte:%{Zso:%e-Zno-rte and -Zso are incompatible}}"		       \
  "%{Zno-rte:%{Zcrtdll*:%e-Zcrtdll and -Zno-rte are incompatible}}"	       \
  "%{Zno-rte:%{Zmt:%e-Zmt and -Zno-rte are incompatible}}"		       \
  "%{Zsys:%{Zcrtdll*:%e-Zcrtdll and -Zsys are incompatible}}"		       \
  "%{Zsys:%{!Zomf:%e-Zsys requires -Zomf}}"				       \
  "%{Zsys:%{Zbsd-signals:%e-Zbsd-signals and -Zsys are incompatible}}"	       \
  "%{Zsys:%{Zsysv-signals:%e-Zsysv-signals and -Zsys are incompatible}}"       \
  "%{Zbsd-signals:%{Zsysv-signals:%e-Zbsd-signals and -Zsysv-signals are incompatible}}" \
  "%{Zsmall-conv:%{Zcrtdll*:%e-Zsmall-conv and -Zcrtdll are incompatible}}"
#endif

/* Actually we're using shared libgcc, but we use it a lot differently ... */
#undef ENABLE_SHARED_LIBGCC
#define LIBGCC_SPEC							       \
  "%{static|static-libgcc:%{shared-libgcc:%e-static-libgcc and -shared-libgcc are incompatible}}"\
  "%{shared-libgcc:-lgcc%v1%v2%v3}"					       \
  "%{!shared-libgcc:%{!static-libgcc:%{Zcrtdll*:-lgcc%v1%v2%v3}}}"	       \
  "%{!shared-libgcc:%{static-libgcc|!Zcrtdll*:-lgcc_eh -lgcc}}"

#ifdef __EMX__LIBCSPECS
#define LIB_SPEC							       \
  "-lc%{p|pg:_p} "							       \
  "%G "                                                                        \
  "%{!Zdll:-lc_app%{pg:_p}} "                                                  \
  "-lc%{p|pg:_p}"
#else
#define LIB_SPEC							       \
  "%{p|pg:-lc_p} -lc "							       \
  "%{Zdll:%{Zso:-lc_dllso}%{Zno-rte:-lc_dllnrt}"			       \
         "%{!Zso:%{!Zno-rte:-lc_dllrt}}}"				       \
  "%{!Zdll:-lc_app%{pg:_p}} "						       \
  "%G %{p|pg:-lc_p} -lc "						       \
  "%{Zdll:%{!Zso:%{!Zno-rte:-lc_dllrt}}}"
#endif

#ifdef __EMX__LIBCSPECS
#define STARTFILE_SPEC							       \
  "%{Zdll:dll0%O%{Zomf:bj}%s}"						       \
  "%{!Zdll:%{pg:gcrt0%O%{Zomf:bj}%s}"					       \
          "%{!pg:%{pn:gcrt0%O%{Zomf:bj}%s}%{!pn:%{p:mcrt0%O%{Zomf:bj}%s}%{!p:crt0%O%{Zomf:bj}%s}}}"\
         " %{Zbin-files:binmode%O%{Zomf:bj}%s} %{Zsmall-conv:smallcnv%O%{Zomf:bj}%s}}"
#else
#define STARTFILE_SPEC							       \
  "%{Zdll:dll0%O%{Zomf:bj}%s}"						       \
  "%{!Zdll:%{pg:gcrt0%O%{Zomf:bj}%s}"					       \
          "%{!pg:%{pn:gcrt0%O%{Zomf:bj}%s}%{!pn:%{p:mcrt0%O%{Zomf:bj}%s}%{!p:crt0%O%{Zomf:bj}%s}}}"\
         " %{Zsysv-signals:sigsysv%O%{Zomf:bj}%s} %{Zbsd-signals:sigbsd%O%{Zomf:bj}%s}"\
         " %{Zbin-files:binmode%O%{Zomf:bj}%s}%{Zsmall-conv:smallcnv%O%{Zomf:bj}%s}}"
#endif

#ifdef __EMX__LIBCSPECS
#define LINK_COMMAND_SPEC						       \
"%{!fsyntax-only: "							       \
 "%{!c:%{!M:%{!MM:%{!E:%{!S:%{Zomf:emxomf}ld "            		       \
			"%l %X %{o*} %{A} %{d} %{e*} %{m} %{N} %{n} "	       \
			"%{r} %{s} %{t} %{u*} %{x} %{z} %{Z} "		       \
			"%{!A:%{!nostdlib:%{!nostartfiles:%S}}} "	       \
			"%{static:} %{L*} %D %{T*} %o "			       \
			"%{!nostdlib:%{!nodefaultlibs:"			       \
	         	   "%G -lc_alias "				       \
                           "%{!Zcrtdll*:%L} %{Zcrtdll*:-lc_dll} -los2%{pg:_p} "\
                           "-lc_alias "                                        \
                           "%{!Zcrtdll*:%L} %{Zcrtdll*:-lc_dll} -los2%{pg:_p} "\
                           "%{Zomf:-lend}"                                     \
                                     "}"                                       \
                         "}"                                                   \
                        "%{!A:%{!nostdlib:%{!nostartfiles:%E}}}"               \
                       "}"                                                     \
                  "}"                                                          \
            "}"                                                                \
       "}"                                                                     \
  "}"                                                                          \
 "}"
#else
#define LINK_COMMAND_SPEC						       \
"%{!fsyntax-only: "							       \
"%{!c:%{!M:%{!MM:%{!E:%{!S:%{!Zomf:ld}%{Zomf:emxomfld} "		       \
			"%l %X %{o*} %{A} %{d} %{e*} %{m} %{N} %{n} "	       \
			"%{r} %{s} %{t} %{u*} %{x} %{z} %{Z} "		       \
			"%{!A:%{!nostdlib:%{!nostartfiles:%S}}} "	       \
			"%{static:} %{L*} %D %{T*} %o "			       \
			"%{!nostdlib:%{!nodefaultlibs:"			       \
			   "-lc_alias %G "				       \
			   "%{Zcrtdll=*:-lc_static -l%* -los2%{pg:_p} -lemx2}" \
			   "%{!Zcrtdll*:%L "				       \
			      "%{Zno-rte:-los2%{pg:_p}} "		       \
			      "%{!Zno-rte:%{Zsys:-lsys -los2} "		       \
			         "%{!Zsys:-lemx -los2%{pg:_p} -lemx2} "	       \
			       "}"					       \
			    "}"						       \
			    "%{Zomf:-lend}}"				       \
			 "}"						       \
			"%{!A:%{!nostdlib:%{!nostartfiles:%E}}} "	       \
                        "}}}}}}"
#endif


/* The following will be defined only when compiling libgcc2
 * to avoid including large .h files when they are not needed.
 * Including them is neccessary to avoid 'implicit declatation'
 * warnings, and also for __write.
 */
#ifdef IN_LIBGCC2
/* define "write" and some other external functions for libgcc */
#define write __write

#include <malloc.h>
#include <alloca.h>
#include <time.h>
#include <string.h>

extern void __ctordtorInit (void);
extern void __ctordtorTerm (void);

/* Invoke static object constructors/destructors */
/* Also register/deregister frame unwind information */
#define DO_GLOBAL_CTORS_BODY __ctordtorInit ()
#define DO_GLOBAL_DTORS_BODY __ctordtorTerm ()

/* We call register_frame_table ourselves */
#define DONT_AUTOREGISTER_FRAME_INFO

#endif

