/* sys/uio.h (emx+gcc) */

#ifndef _SYS_UIO_H
#define _SYS_UIO_H
#define _SYS_UIO_H_ /*toolkit pollution*/

#if defined (__cplusplus)
extern "C" {
#endif

struct iovec
{
  caddr_t iov_base;
#if defined(__32BIT__) && !defined(TCPV40HDRS)
  size_t  iov_len;
#else
  int     iov_len;
#endif
};


/* needed for sys\socket.h TCPIPV4 now */
#ifdef TCPV40HDRS
struct uio {
	struct iovec	*uio_iov;
	int		uio_iovcnt;
	off_t		uio_offset;
	int		uio_segflg;
	unsigned int	uio_resid;
};
#ifndef FREAD
#define FREAD   1
#define FWRITE  2
#endif
#endif

enum	uio_rw { UIO_READ, UIO_WRITE };

#ifndef TCPV40HDRS
/* Segment flag values. */
enum uio_seg {
        UIO_USERSPACE,          /* from user data space */
        UIO_SYSSPACE,           /* from system space */
        UIO_USERISPACE          /* from user I space */
};
#endif

/** @name tcpip40 function mappings.
 * @{ */
//@@@ name conflict - a.z. #define readv         tcpip40_readv
//@@@ name conflict - a.z. #define writev        tcpip40_writev
/* @} */

//@@@ name conflict - a.z. int _System readv (int, __const__ struct iovec *, int);
//@@@ name conflict - a.z. int _System writev (int, __const__ struct iovec *, int);

#if defined (__cplusplus)
}
#endif

#endif /* not _SYS_UIO_H */
