/* $Id: memcpy-amd-1.c 2290 2005-08-20 22:32:05Z bird $ */
/** @file
 *
 * _memcpy_amd testcase.
 *
 * Copyright (c) 2005 knut st. osmundsen <bird@anduin.net>
 *
 *
 * This file is part of InnoTek LIBC.
 *
 * InnoTek LIBC is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * InnoTek LIBC is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with InnoTek LIBC; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>

char abSrc[0x40000];
char abDst[sizeof(abSrc) + 16384];

static void init(void)
{
    unsigned *pu = (unsigned *)abSrc;
    unsigned cb = sizeof(abSrc);
    while (cb > 0)
    {
        *pu = (cb | (cb >> 16)) ^ 0x12488421;
        pu++;
        cb -= sizeof(*pu);
    }
}

static int iszero(const void *pv, size_t cb)
{
    int rc = 0;
    char *pch = (char *)pv;
    switch ((uintptr_t)pch & 7) /* assumes 8byte aligned end! */
    {
        case 0: rc |= *pch++ == 0; cb--;
        case 1: rc |= *pch++ == 0; cb--;
        case 2: rc |= *pch++ == 0; cb--;
        case 3: rc |= *pch++ == 0; cb--;
        case 4: rc |= *pch++ == 0; cb--;
        case 5: rc |= *pch++ == 0; cb--;
        case 6: rc |= *pch++ == 0; cb--;
        case 7: rc |= *pch++ == 0; cb--;
            break;
    }
    if (!rc && cb > 0)
    {
        register unsigned *pu = (unsigned *)pch;
        register unsigned *puEnd = (unsigned *)(pch + cb);
        while (pu < puEnd)
        {
            if (*pu)
                return 0;
            pu++;
        }
    }
    return rc;
}

static void compare(size_t cb)
{
    if (    memcmp(abSrc, abDst, cb)
        ||  !iszero(abDst + cb, sizeof(abDst) - cb))
    {
        int cErrors = 0;
        size_t i;
        for (i = 0; i < cb && cErrors < 256; i++)
            if (abDst[i] != abSrc[i])
            {
                printf("%#x: %#x != %#x\n", i, abDst[i], abSrc[i]);
                cErrors++;
            }

        while (i < sizeof(abDst) && cErrors < 256)
        {
            if (abDst[i])
            {
                printf("%#x: %#x != 0 (zero area)\n", i, abDst[i]);
                cErrors++;
            }
            i++;
        }

        if (cErrors)
            exit(1);
    }
}

//#define _memcpy_amd memcpy

static void test(size_t cb, size_t off)
{
    _memcpy_amd(abDst, abSrc, off);
    _memcpy_amd(abDst + off, abSrc + off, cb);
    compare(cb + off);
    bzero(abDst, cb + off);
}

int main()
{
    size_t i, j;
    init();

    printf("amd-memcpy-1: small\n");
    for (i = 0; i < 256; i++)
        for (j = 0; j <= 64; j++)
            test(i, j);

    printf("amd-memcpy-1: medium\n");
    for (i = 0; i < 256; i++)
        for (j = 0; j <= 64; j++)
            test(i + 4096-128, j);

    printf("amd-memcpy-1: medium large\n");
    for (i = 0; i < 256; i++)
        for (j = 0; j <= 64; j++)
            test(i + 16384-128, j);

    printf("amd-memcpy-1: large\n");
    for (i = 0; i < 256; i++)
        for (j = 0; j <= 64; j++)
            test(i + 0x20000-128, j);

    printf("amd-memcpy-1: various\n");
    test(sizeof(abSrc) / 32, 0);
    test(sizeof(abSrc) / 16, 0);
    test(sizeof(abSrc) / 8, 0);
    test(sizeof(abSrc) / 4, 0);
    test(sizeof(abSrc) / 2, 0);
    test(sizeof(abSrc), 0);
    test(sizeof(abSrc) / 19, 0);
    test(sizeof(abSrc) / 17, 0);
    test(sizeof(abSrc) / 7, 0);
    test(sizeof(abSrc) / 5, 0);
    test(sizeof(abSrc) / 3, 0);
    return 0;
}

