/* $Id: dll0.s 2289 2005-08-20 22:08:50Z bird $ */
/** @file
 *
 * Standard entry point for dynamic libraries.
 * This routine gets control right after dynamic library is loaded.
 *
 *
 * Copyright (c) 1992-1998 by Eberhard Mattes
 * Copyright (c) 2003 InnoTek Systemberatung GmbH
 *
 *
 * This file is part of Innotek LIBC.
 *
 * Innotek LIBC is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Innotek LIBC is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with Innotek LIBC; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#include <emx/asm386.h>

    .globl  __text
    .globl  __data
    .globl  ___data_start
    .globl  ___bss_start

    .text


#if defined(HIGHMEM)
#define FLAG_HIGHMEM    1
#else
#define FLAG_HIGHMEM    0
#endif

#if defined(NOUNIX)
#define FLAG_NOUNIX     2
#else
#define FLAG_NOUNIX     0
#endif

__text:
    cmpl    $0, 8(%esp)
    jz      do_common_init
    jmp     do_initterm

    /*
     * Nonstandard: we're doing some early initializations.
     */
do_common_init:
#if !defined(NOFORK) && !defined(NOUNIX)
    pushl   $0
    pushl   $ForkModule
    call    ___libc_ForkRegisterModule
    addl    $8, %esp
    cmpl    $0, %eax
    je      do_init
    jg      do_fork

    /* return failure (eax < 0). */
    xorl    %eax, %eax
    ret

    /* return success - we're forking; no init. */
do_fork:
    xorl    %eax, %eax
    inc     %al
    ret

    /* normal dll init. */
do_init:
#endif
    pushl   4(%esp)
    pushl   $(FLAG_HIGHMEM + FLAG_NOUNIX)
    call    ___init_dll
    add     $8, %esp
    orl     %eax, %eax
    jz      do_initterm
    /*
     * __init_dll() failed - fail the dll loading.
     */
    xorl    %eax, %eax
    ret

    /*
     * Standard initialization.
     */
do_initterm:
    cld
    jmp     _DLL_InitTerm


    .data
__data:
___data_start:
    .long   0xba0bab    // Magic number (error detection)
    .long   __os2dll    // list of OS/2 DLL references

    .stabs  "__os2dll", 21, 0, 0, 0xffffffff
    .stabs  "___CTOR_LIST__", 21, 0, 0, 0xffffffff
    .stabs  "___DTOR_LIST__", 21, 0, 0, 0xffffffff
    .stabs  "___crtinit1__", 21, 0, 0, 0xffffffff
    .stabs  "___crtexit1__", 21, 0, 0, 0xffffffff
    .stabs  "___eh_frame__", 21, 0, 0, 0xffffffff
    .stabs  "___eh_init__", 21, 0, 0, 0xffffffff
    .stabs  "___eh_term__", 21, 0, 0, 0xffffffff
#if !defined(NOFORK) && !defined(NOUNIX)
    .stabs  "___fork_parent1__", 21, 0, 0, 0xffffffff
    .stabs  "___fork_child1__", 21, 0, 0, 0xffffffff

ForkModule:
    .long  0x00010000                   // uVersion (__LIBC_FORK_MODULE_VERSION)
    .long  __atfork_callback            // pfnAtFork
    .long  ___fork_parent1__            // papParent1
    .long  ___fork_child1__             // papChild1
    .long  ___data_start                // pvDataSegBase
    .long  _end                         // pvDataSegEnd
    .long  0                            // fFlags
    .long  0                            // pNext
    .long  0                            // uReserved[8]
    .long  0                            // uReserved[8]
    .long  0                            // uReserved[8]
    .long  0                            // uReserved[8]
    .long  0                            // uReserved[8]
    .long  0                            // uReserved[8]
    .long  0                            // uReserved[8]
    .long  0                            // uReserved[8]
#endif
    .stabs "__end",1,0,0,0              /* force libend inclusion for -Zomf. */

    .bss
___bss_start:

