/* $Id: cpuid.c 2280 2005-08-20 21:24:40Z bird $ */
/** @file
 *
 * The start of a cpuid dumper.
 *
 * Copyright (c) 2005 knut st. osmundsen <bird@anduin.net>
 *
 *
 * This file is part of InnoTek LIBC.
 *
 * InnoTek LIBC is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * InnoTek LIBC is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with InnoTek LIBC; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#include <stdio.h>

#define BIT(n) (1 << n)
int main()
{
    unsigned  eax, edx, ecx, ebx;
    __asm__ ("cpuid" : "=a" (eax), "=d" (edx), "=c" (ecx), "=b" (ebx) : "0" (1));
    printf("1: edx=%#x ecx=%#x eax=%#x ebx=%#x\n", edx, ecx, eax, ebx);
    if (edx & BIT(0))   printf("FPU ");
    if (edx & BIT(1))   printf("VME ");
    if (edx & BIT(2))   printf("DE ");
    if (edx & BIT(3))   printf("PSE ");
    if (edx & BIT(4))   printf("TSC ");
    if (edx & BIT(5))   printf("MSR ");
    if (edx & BIT(6))   printf("PAE ");
    if (edx & BIT(7))   printf("MCE ");
    if (edx & BIT(8))   printf("CX8 ");
    if (edx & BIT(9))   printf("APIC ");
    if (edx & BIT(10))  printf("10 ");
    if (edx & BIT(11))  printf("SEP ");
    if (edx & BIT(12))  printf("MTRR ");
    if (edx & BIT(13))  printf("PGE ");
    if (edx & BIT(14))  printf("MCA ");
    if (edx & BIT(15))  printf("CMOV ");
    if (edx & BIT(16))  printf("PAT ");
    if (edx & BIT(17))  printf("PSE36 ");
    if (edx & BIT(18))  printf("PSN ");
    if (edx & BIT(19))  printf("CLFSH ");
    if (edx & BIT(20))  printf("20 ");
    if (edx & BIT(21))  printf("DS ");
    if (edx & BIT(22))  printf("ACPI ");
    if (edx & BIT(23))  printf("MMX ");
    if (edx & BIT(24))  printf("FXSR ");
    if (edx & BIT(25))  printf("SSE ");
    if (edx & BIT(26))  printf("SSE2 ");
    if (edx & BIT(27))  printf("SS ");
    if (edx & BIT(28))  printf("28 ");
    if (edx & BIT(29))  printf("29 ");
    if (edx & BIT(30))  printf("30 ");
    if (edx & BIT(31))  printf("31 ");
    printf("\n");

    return 0;
}
