/* $Id: dllinit.c 2254 2005-07-17 12:25:44Z bird $ */
/** @file
 * Default DLL init and termination code.
 */

#include <emx/startup.h>
#define __LIBC_LOG_GROUP __LIBC_LOG_GRP_INITTERM
#include <InnoTekLIBC/logstrict.h>


/**
 * This is the typical DLL startup code.
 *
 * @returns 1 on success.
 * @returns 0 on failure.
 * @param   hmod    Handle of this DLL.
 * @param   flag    0 init.
 *                  1 term.
 * @remark  This function is called from dll0.asm.
 */
unsigned _System _DLL_InitTerm(unsigned hmod, unsigned flag)
{
    LIBCLOG_ENTER("hmod=%#x flag=%d\n", hmod, flag);
    switch (flag)
    {
        case 0:
            if (_CRT_init() != 0)
                break;
            __ctordtorInit();
            LIBCLOG_RETURN_INT(1);
        case 1:
            __ctordtorTerm();
            _CRT_term();
            LIBCLOG_RETURN_INT(1);
    }
    LIBCLOG_ERROR_RETURN_INT(0);
}

