/* $Id: wait3.c 2254 2005-07-17 12:25:44Z bird $ */
/** @file
 *
 * LIBC - wait3().
 *
 * Copyright (c) 2004 knut st. osmundsen <bird@innotek.de>
 *
 *
 * This file is part of InnoTek LIBC.
 *
 * InnoTek LIBC is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * InnoTek LIBC is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with InnoTek LIBC; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */


/*******************************************************************************
*   Header Files                                                               *
*******************************************************************************/
#include "libc-alias.h"
#include <sys/wait.h>
#include <errno.h>
#include <InnoTekLIBC/backend.h>
#define __LIBC_LOG_GROUP __LIBC_LOG_GRP_PROCESS
#include <InnoTekLIBC/logstrict.h>


/**
 * Waits/polls for a child process to change it's running status.
 *
 * @returns Process id of the child.
 * @returns -1 and errno on failure.
 * @param   piStatus    Where to return the status.
 * @param   fOptions    Same as waitid() in our implementation.
 * @param   pRUsage     Where to return the resource usage of the child. (Optional)
 *                      This is not implemented yet - the call fails if specified.
 */
pid_t _STD(wait3)(int *piStatus, int fOptions, struct rusage *pRUsage)
{
    LIBCLOG_ENTER("piStatus=%p fOptions=%#x pRUsage=%p\n", (void *)piStatus, fOptions, (void *)pRUsage);
    /*
     * Just pass it along to wait4().
     */
    pid_t pid = wait4(-1, piStatus, fOptions, pRUsage);
    if (pid >= 0)
        LIBCLOG_RETURN_MSG(pid, "ret %d (%#x) iStatus=%#x\n", pid, pid, piStatus ? *piStatus : -1);
    LIBCLOG_ERROR_RETURN_INT(pid);
}

