/* $Id: libc-alias-glibc.h 2144 2005-07-02 02:31:40Z bird $ */
/** @file
 *
 * Innotek LIBC aliasing for GLIBC.
 *
 * Routes the __<stdname> to it's appropriate Innotek LIBC implementation.
 *
 * Copyright (c) 2004 knut st. osmundsen <bird-srcspam@anduin.net>
 *
 *
 * This file is part of Innotek LIBC.
 *
 * Innotek LIBC is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Innotek LIBC is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with Innotek LIBC; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
#ifndef __libc_alias_glibc_h__
#define __libc_alias_glibc_h__

#include "libc-alias.h"

/* a little hack */
#undef _GNU_SOURCE
#define _GNU_SOURCE
#undef _BSD_SOURCE
#define _BSD_SOURCE
#undef _SVID_SOURCE
#define _SVID_SOURCE
#undef _POSIX_SOURCE
#undef _POSIX_C_SOURCE
#include <sys/cdefs.h>

#ifndef _LIBC_SYMBOLS_H /* hackityhack */
#undef weak_alias
#define weak_alias(name, aliasname)
#undef INTDEF
#define INTDEF(name)
#define libc_hidden_def(name)
#endif

#define __stpcpy(d, s) stpcpy(d, s)

/* Generated from libc-std.h using:
 *  sed -e "/^#define.*_STD(/!d" -e "s/#define \([a-zA-Z0-9_]*\) /#define __\1 /"
 */
#define __mrand48 _STD(mrand48)
#define __memmove _STD(memmove)
#define __floorf _STD(floorf)
#define __getppid _STD(getppid)
#define __execv _STD(execv)
#define __ioctl _STD(ioctl)
#define __tcsendbreak _STD(tcsendbreak)
#define __seed48 _STD(seed48)
#define __fmodf _STD(fmodf)
#define __rand _STD(rand)
#define __strdup _STD(strdup)
#define __rindex _STD(rindex)
#define __strnset _STD(strnset)
#define __read _STD(read)
#define __putenv _STD(putenv)
#define __fgetpos _STD(fgetpos)
#define __bsearch _STD(bsearch)
#define __floorl _STD(floorl)
#define __localtime _STD(localtime)
#define __pause _STD(pause)
#define __execle _STD(execle)
#define __getpagesize _STD(getpagesize)
#define __rewind _STD(rewind)
#define __strtoll _STD(strtoll)
#define __pipe _STD(pipe)
#define __insque _STD(insque)
#define __sigsuspend _STD(sigsuspend)
#define __fmodl _STD(fmodl)
#define __setvbuf _STD(setvbuf)
#define __powf _STD(powf)
#define __setgid _STD(setgid)
#define __posix_memalign _STD(posix_memalign)
#define __tzname _STD(tzname)
#define __spawnlpe _STD(spawnlpe)
#define __sys_nerr _STD(sys_nerr)
#define __hypotf _STD(hypotf)
#define __getpass _STD(getpass)
#define __localtime_r _STD(localtime_r)
#define __getpwuid _STD(getpwuid)
#define __printf _STD(printf)
#define __fgetc _STD(fgetc)
#define __memicmp _STD(memicmp)
#define __spawnl _STD(spawnl)
#define __sinhf _STD(sinhf)
#define __ceil _STD(ceil)
#define __spawnle _STD(spawnle)
#define __lcong48 _STD(lcong48)
#define __powl _STD(powl)
#define __cfgetospeed _STD(cfgetospeed)
#define __getenv _STD(getenv)
#define __qsort _STD(qsort)
#define __sigdelset _STD(sigdelset)
#define __setmode _STD(setmode)
#define __malloc _STD(malloc)
#define __hypotl _STD(hypotl)
#define __execlp _STD(execlp)
#define __fscanf _STD(fscanf)
#define __floor _STD(floor)
#define __nextafter _STD(nextafter)
#define __strupr _STD(strupr)
#define __scanf _STD(scanf)
#define __sinhl _STD(sinhl)
#define __cfsetispeed _STD(cfsetispeed)
#define __exit _STD(exit)
#define __setuid _STD(setuid)
#define __realpath _STD(realpath)
#define __logf _STD(logf)
#define __tcgetattr _STD(tcgetattr)
#define __strcoll _STD(strcoll)
#define __tmpfile _STD(tmpfile)
#define __timezone _STD(timezone)
#define __sbrk _STD(sbrk)
#define __strcspn _STD(strcspn)
#define __pathconf _STD(pathconf)
#define __bzero _STD(bzero)
#define __log _STD(log)
#define __spawnv _STD(spawnv)
#define __sysconf _STD(sysconf)
#define __ftruncate _STD(ftruncate)
#define __gcvt _STD(gcvt)
#define __sigsetjmp _STD(sigsetjmp)
#define __pow _STD(pow)
#define __cfsetspeed _STD(cfsetspeed)
#define __sleep _STD(sleep)
#define __spawnlp _STD(spawnlp)
#define __sprintf _STD(sprintf)
#define __cbrtl _STD(cbrtl)
#define __writev _STD(writev)
#define __ffs _STD(ffs)
#define __strftime _STD(strftime)
#define __strtoimax _STD(strtoimax)
#define __tanhf _STD(tanhf)
#define __logl _STD(logl)
#define __opendir _STD(opendir)
#define __fprintf _STD(fprintf)
#define __erand48 _STD(erand48)
#define __acos _STD(acos)
#define __gmtime _STD(gmtime)
#define __srand _STD(srand)
#define __fgets _STD(fgets)
#define __mbtowc _STD(mbtowc)
#define __asctime _STD(asctime)
#define __utimes _STD(utimes)
#define __isatty _STD(isatty)
#define __getopt _STD(getopt)
#define __strcpy _STD(strcpy)
#define __ftell _STD(ftell)
#define __memcpy _STD(memcpy)
#define __ctime _STD(ctime)
#define __stat _STD(stat)
#define __tdelete _STD(tdelete)
#define __sqrtf _STD(sqrtf)
#define __tanhl _STD(tanhl)
#define __cbrt _STD(cbrt)
#define __closedir _STD(closedir)
#define __hdestroy _STD(hdestroy)
#define __bcopy _STD(bcopy)
#define __strerror_r _STD(strerror_r)
#define __expand _STD(expand)
#define __readdir_r _STD(readdir_r)
#define __strcat _STD(strcat)
#define __rintf _STD(rintf)
#define __fabs _STD(fabs)
#define __settimeofday _STD(settimeofday)
#define __clock _STD(clock)
#define __spawnvpe _STD(spawnvpe)
#define __getgroups _STD(getgroups)
#define __getcwd _STD(getcwd)
#define __fgetchar _STD(fgetchar)
#define __modff _STD(modff)
#define __cos _STD(cos)
#define __atan2 _STD(atan2)
#define __sopen _STD(sopen)
#define __strtod _STD(strtod)
#define __sqrtl _STD(sqrtl)
#define __calloc _STD(calloc)
#define __mblen _STD(mblen)
#define __fseeko _STD(fseeko)
#define __imaxdiv _STD(imaxdiv)
#define __ldexp _STD(ldexp)
#define __strtof _STD(strtof)
#define __setbuf _STD(setbuf)
#define __execve _STD(execve)
#define __setlocale _STD(setlocale)
#define __glob _STD(glob)
#define __strlen _STD(strlen)
#define __rintl _STD(rintl)
#define __getpwent _STD(getpwent)
#define __modfl _STD(modfl)
#define __stricmp _STD(stricmp)
#define __ulimit _STD(ulimit)
#define __strtok _STD(strtok)
#define __sscanf _STD(sscanf)
#define __tsearch _STD(tsearch)
#define __modf _STD(modf)
#define __strnicmp _STD(strnicmp)
#define __strncpy _STD(strncpy)
#define __getwd _STD(getwd)
#define __creat _STD(creat)
#define __rewinddir _STD(rewinddir)
#define __strtol _STD(strtol)
#define __abort _STD(abort)
#define __copysignf _STD(copysignf)
#define __waitpid _STD(waitpid)
#define __div _STD(div)
#define __cuserid _STD(cuserid)
#define __siglongjmp _STD(siglongjmp)
#define __spawnve _STD(spawnve)
#define __longjmp _STD(longjmp)
#define __getegid _STD(getegid)
#define __setbuffer _STD(setbuffer)
#define __strptime _STD(strptime)
#define __ctime_r _STD(ctime_r)
#define __strncat _STD(strncat)
#define __getpwnam _STD(getpwnam)
#define __fnmatch _STD(fnmatch)
#define __ftello _STD(ftello)
#define __log10 _STD(log10)
#define __copysignl _STD(copysignl)
#define __execvp _STD(execvp)
#define __setenv _STD(setenv)
#define __fdopen _STD(fdopen)
#define __sigemptyset _STD(sigemptyset)
#define __uname _STD(uname)
#define __lrand48 _STD(lrand48)
#define __nrand48 _STD(nrand48)
#define __times _STD(times)
#define __tcgetpgrp _STD(tcgetpgrp)
#define __utime _STD(utime)
#define __fputc _STD(fputc)
#define __ltoa _STD(ltoa)
#define __exp _STD(exp)
#define __coshf _STD(coshf)
#define __setpwent _STD(setpwent)
#define __fsetpos _STD(fsetpos)
#define __lseek _STD(lseek)
#define __chsize _STD(chsize)
#define __ttyname _STD(ttyname)
#define __cfgetispeed _STD(cfgetispeed)
#define __spawnvp _STD(spawnvp)
#define __gmtime_r _STD(gmtime_r)
#define __getgrgid _STD(getgrgid)
#define __geteuid _STD(geteuid)
#define __fflush _STD(fflush)
#define __memccpy _STD(memccpy)
#define __index _STD(index)
#define __coshl _STD(coshl)
#define __mkdir _STD(mkdir)
#define __free _STD(free)
#define __flushall _STD(flushall)
#define __qsort_r _STD(qsort_r)
#define __strerror _STD(strerror)
#define __system _STD(system)
#define __difftime _STD(difftime)
#define __copysign _STD(copysign)
#define __getlogin _STD(getlogin)
#define __putchar _STD(putchar)
#define __snprintf _STD(snprintf)
#define __hcreate _STD(hcreate)
#define __strrchr _STD(strrchr)
#define __cosf _STD(cosf)
#define __atan _STD(atan)
#define __asin _STD(asin)
#define __labs _STD(labs)
#define __localeconv _STD(localeconv)
#define __tempnam _STD(tempnam)
#define __jrand48 _STD(jrand48)
#define __sqrt _STD(sqrt)
#define __realloc _STD(realloc)
#define __lockf _STD(lockf)
#define __cosh _STD(cosh)
#define __setpgid _STD(setpgid)
#define __fcntl _STD(fcntl)
#define __dirname _STD(dirname)
#define __vfscanf _STD(vfscanf)
#define __gets _STD(gets)
#define __sinf _STD(sinf)
#define __log10f _STD(log10f)
#define __tell _STD(tell)
#define __fputs _STD(fputs)
#define __strcmp _STD(strcmp)
#define __sinh _STD(sinh)
#define __memcmp _STD(memcmp)
#define __cosl _STD(cosl)
#define __ftime _STD(ftime)
#define __raise _STD(raise)
#define __brk _STD(brk)
#define __ulltoa _STD(ulltoa)
#define __getw _STD(getw)
#define __chdrive _STD(chdrive)
#define __sys_errlist _STD(sys_errlist)
#define __strtoumax _STD(strtoumax)
#define __vsnprintf _STD(vsnprintf)
#define __lfind _STD(lfind)
#define __tan _STD(tan)
#define __sinl _STD(sinl)
#define __sin _STD(sin)
#define __atofl _STD(atofl)
#define __chdir _STD(chdir)
#define __pclose _STD(pclose)
#define __clearerr _STD(clearerr)
#define __tfind _STD(tfind)
#define __log10l _STD(log10l)
#define __ftw _STD(ftw)
#define __fpathconf _STD(fpathconf)
#define __fopen _STD(fopen)
#define __nextafterf _STD(nextafterf)
#define __asctime_r _STD(asctime_r)
#define __sigaction _STD(sigaction)
#define __kill _STD(kill)
#define __mkstemp _STD(mkstemp)
#define __eof _STD(eof)
#define __ceilf _STD(ceilf)
#define __tcflush _STD(tcflush)
#define __getpid _STD(getpid)
#define __fseek _STD(fseek)
#define __readv _STD(readv)
#define __srand48 _STD(srand48)
#define __execlpe _STD(execlpe)
#define __vprintf _STD(vprintf)
#define __filelength _STD(filelength)
#define __fwrite _STD(fwrite)
#define __tzset _STD(tzset)
#define __sigaddset _STD(sigaddset)
#define __getgid _STD(getgid)
#define __atexit _STD(atexit)
#define __chmod _STD(chmod)
#define __dup _STD(dup)
#define __write _STD(write)
#define __select _STD(select)
#define __fmod _STD(fmod)
#define __fabsf _STD(fabsf)
#define __acosf _STD(acosf)
#define __signal _STD(signal)
#define __sigismember _STD(sigismember)
#define __nextafterl _STD(nextafterl)
#define __mktime _STD(mktime)
#define __strspn _STD(strspn)
#define __close _STD(close)
#define __ceill _STD(ceill)
#define __readdir _STD(readdir)
#define __asinf _STD(asinf)
#define __lsearch _STD(lsearch)
#define __tanf _STD(tanf)
#define __atanf _STD(atanf)
#define __strxfrm _STD(strxfrm)
#define __strncmp _STD(strncmp)
#define __fread _STD(fread)
#define __tcsetattr _STD(tcsetattr)
#define __tanh _STD(tanh)
#define __fabsl _STD(fabsl)
#define __acosl _STD(acosl)
#define __strrev _STD(strrev)
#define __setsid _STD(setsid)
#define __perror _STD(perror)
#define __strtoull _STD(strtoull)
#define __fileno _STD(fileno)
#define __lstat _STD(lstat)
#define __atan2f _STD(atan2f)
#define __fsync _STD(fsync)
#define __vscanf _STD(vscanf)
#define __truncate _STD(truncate)
#define __twalk _STD(twalk)
#define __expf _STD(expf)
#define __asinl _STD(asinl)
#define __gettimeofday _STD(gettimeofday)
#define __umask _STD(umask)
#define __getuid _STD(getuid)
#define __tanl _STD(tanl)
#define __atanl _STD(atanl)
#define __strpbrk _STD(strpbrk)
#define __fork _STD(fork)
#define __flock _STD(flock)
#define __swab _STD(swab)
#define __ungetc _STD(ungetc)
#define __sigprocmask _STD(sigprocmask)
#define __dup2 _STD(dup2)
#define __vsscanf _STD(vsscanf)
#define __drand48 _STD(drand48)
#define __trunc _STD(trunc)
#define __atan2l _STD(atan2l)
#define __tcflow _STD(tcflow)
#define __wcstombs _STD(wcstombs)
#define __atoll _STD(atoll)
#define __remque _STD(remque)
#define __expl _STD(expl)
#define __seekdir _STD(seekdir)
#define __fclose _STD(fclose)
#define __strtoul _STD(strtoul)
#define __cfsetospeed _STD(cfsetospeed)
#define __sigfillset _STD(sigfillset)
#define __lltoa _STD(lltoa)
#define __tmpnam _STD(tmpnam)
#define __hsearch _STD(hsearch)
#define __getpw _STD(getpw)
#define __strstr _STD(strstr)
#define __popen _STD(popen)
#define __truncf _STD(truncf)
#define __rmdir _STD(rmdir)
#define __getchar _STD(getchar)
#define __ldexpf _STD(ldexpf)
#define __daylight _STD(daylight)
#define __basename _STD(basename)
#define __execvpe _STD(execvpe)
#define __tcsetpgrp _STD(tcsetpgrp)
#define __strlwr _STD(strlwr)
#define __getpgrp _STD(getpgrp)
#define __wait _STD(wait)
#define __atof _STD(atof)
#define __truncl _STD(truncl)
#define __remove _STD(remove)
#define __getgrnam _STD(getgrnam)
#define __mbstowcs _STD(mbstowcs)
#define __mktemp _STD(mktemp)
#define __ldexpl _STD(ldexpl)
#define __endpwent _STD(endpwent)
#define __ferror _STD(ferror)
#define __access _STD(access)
#define __atoi _STD(atoi)
#define __frexpf _STD(frexpf)
#define __vsprintf _STD(vsprintf)
#define __rint _STD(rint)
#define __unlink _STD(unlink)
#define __fstat _STD(fstat)
#define __bcmp _STD(bcmp)
#define __atol _STD(atol)
#define __unsetenv _STD(unsetenv)
#define __puts _STD(puts)
#define __vfprintf _STD(vfprintf)
#define __ldiv _STD(ldiv)
#define __strset _STD(strset)
#define __execl _STD(execl)
#define __feof _STD(feof)
#define __wctomb _STD(wctomb)
#define __imaxabs _STD(imaxabs)
#define __memset _STD(memset)
#define __frexp _STD(frexp)
#define __time _STD(time)
#define __setjmp _STD(setjmp)
#define __rename _STD(rename)
#define __frexpl _STD(frexpl)
#define __tcdrain _STD(tcdrain)
#define __putw _STD(putw)
#define __strchr _STD(strchr)
#define __open _STD(open)
#define __memchr _STD(memchr)
#define __ultoa _STD(ultoa)
#define __telldir _STD(telldir)
#define __fputchar _STD(fputchar)
#define __globfree _STD(globfree)
#define __hypot _STD(hypot)
#define __sigpending _STD(sigpending)
#define __strtold _STD(strtold)
#define __freopen _STD(freopen)
#define __abs _STD(abs)
#define __environ _STD(environ)
#define __strcasecmp _STD(stricmp)
#define __strncasecmp _STD(strnicmp)
#define __flockfile _STD(flockfile)
#define __ftrylockfile _STD(ftrylockfile)
#define __funlockfile _STD(funlockfile)

#endif
