/* $Id: locale_ctype.c 2058 2005-06-23 05:58:05Z bird $ */
/** @file
 *
 * Locale - ctype data.
 *
 * Copyright (c) 2003 InnoTek Systemberatung GmbH
 * Copyright (c) 2003-2004 knut st. osmundsen <bird-srcspam@anduin.net>
 *
 *
 * This file is part of InnoTek LIBC.
 *
 * InnoTek LIBC is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * InnoTek LIBC is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with InnoTek LIBC; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#define _DONT_USE_CTYPE_INLINE_
#include "libc-alias.h"
#define INCL_FSMACROS
#include <os2emx.h>
#include <InnoTekLIBC/locale.h>
#include <ctype.h>


/** Character case conversion tables. */
__LIBC_LOCALECTYPE       __libc_GLocaleCtype =
{
    .auchUpper =
    {
        0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f,
        0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17, 0x18, 0x19, 0x1a, 0x1b, 0x1c, 0x1d, 0x1e, 0x1f,
        0x20, 0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27, 0x28, 0x29, 0x2a, 0x2b, 0x2c, 0x2d, 0x2e, 0x2f,
        0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x3a, 0x3b, 0x3c, 0x3d, 0x3e, 0x3f,
        0x40, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47, 0x48, 0x49, 0x4a, 0x4b, 0x4c, 0x4d, 0x4e, 0x4f,
        0x50, 0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x57, 0x58, 0x59, 0x5a, 0x5b, 0x5c, 0x5d, 0x5e, 0x5f,
        0x60, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47, 0x48, 0x49, 0x4a, 0x4b, 0x4c, 0x4d, 0x4e, 0x4f,
        0x50, 0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x57, 0x58, 0x59, 0x5a, 0x7b, 0x7c, 0x7d, 0x7e, 0x7f,
        0x80, 0x81, 0x82, 0x83, 0x84, 0x85, 0x86, 0x87, 0x88, 0x89, 0x8a, 0x8b, 0x8c, 0x8d, 0x8e, 0x8f,
        0x90, 0x91, 0x92, 0x93, 0x94, 0x95, 0x96, 0x97, 0x98, 0x99, 0x9a, 0x9b, 0x9c, 0x9d, 0x9e, 0x9f,
        0xa0, 0xa1, 0xa2, 0xa3, 0xa4, 0xa5, 0xa6, 0xa7, 0xa8, 0xa9, 0xaa, 0xab, 0xac, 0xad, 0xae, 0xaf,
        0xb0, 0xb1, 0xb2, 0xb3, 0xb4, 0xb5, 0xb6, 0xb7, 0xb8, 0xb9, 0xba, 0xbb, 0xbc, 0xbd, 0xbe, 0xbf,
        0xc0, 0xc1, 0xc2, 0xc3, 0xc4, 0xc5, 0xc6, 0xc7, 0xc8, 0xc9, 0xca, 0xcb, 0xcc, 0xcd, 0xce, 0xcf,
        0xd0, 0xd1, 0xd2, 0xd3, 0xd4, 0xd5, 0xd6, 0xd7, 0xd8, 0xd9, 0xda, 0xdb, 0xdc, 0xdd, 0xde, 0xdf,
        0xe0, 0xe1, 0xe2, 0xe3, 0xe4, 0xe5, 0xe6, 0xe7, 0xe8, 0xe9, 0xea, 0xeb, 0xec, 0xed, 0xee, 0xef,
        0xf0, 0xf1, 0xf2, 0xf3, 0xf4, 0xf5, 0xf6, 0xf7, 0xf8, 0xf9, 0xfa, 0xfb, 0xfc, 0xfd, 0xfe, 0xff,
    },
    .auchLower =
    {
        0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f,
        0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17, 0x18, 0x19, 0x1a, 0x1b, 0x1c, 0x1d, 0x1e, 0x1f,
        0x20, 0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27, 0x28, 0x29, 0x2a, 0x2b, 0x2c, 0x2d, 0x2e, 0x2f,
        0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x3a, 0x3b, 0x3c, 0x3d, 0x3e, 0x3f,
        0x40, 0x61, 0x62, 0x63, 0x64, 0x65, 0x66, 0x67, 0x68, 0x69, 0x6a, 0x6b, 0x6c, 0x6d, 0x6e, 0x6f,
        0x70, 0x71, 0x72, 0x73, 0x74, 0x75, 0x76, 0x77, 0x78, 0x79, 0x7a, 0x5b, 0x5c, 0x5d, 0x5e, 0x5f,
        0x60, 0x61, 0x62, 0x63, 0x64, 0x65, 0x66, 0x67, 0x68, 0x69, 0x6a, 0x6b, 0x6c, 0x6d, 0x6e, 0x6f,
        0x70, 0x71, 0x72, 0x73, 0x74, 0x75, 0x76, 0x77, 0x78, 0x79, 0x7a, 0x7b, 0x7c, 0x7d, 0x7e, 0x7f,
        0x80, 0x81, 0x82, 0x83, 0x84, 0x85, 0x86, 0x87, 0x88, 0x89, 0x8a, 0x8b, 0x8c, 0x8d, 0x8e, 0x8f,
        0x90, 0x91, 0x92, 0x93, 0x94, 0x95, 0x96, 0x97, 0x98, 0x99, 0x9a, 0x9b, 0x9c, 0x9d, 0x9e, 0x9f,
        0xa0, 0xa1, 0xa2, 0xa3, 0xa4, 0xa5, 0xa6, 0xa7, 0xa8, 0xa9, 0xaa, 0xab, 0xac, 0xad, 0xae, 0xaf,
        0xb0, 0xb1, 0xb2, 0xb3, 0xb4, 0xb5, 0xb6, 0xb7, 0xb8, 0xb9, 0xba, 0xbb, 0xbc, 0xbd, 0xbe, 0xbf,
        0xc0, 0xc1, 0xc2, 0xc3, 0xc4, 0xc5, 0xc6, 0xc7, 0xc8, 0xc9, 0xca, 0xcb, 0xcc, 0xcd, 0xce, 0xcf,
        0xd0, 0xd1, 0xd2, 0xd3, 0xd4, 0xd5, 0xd6, 0xd7, 0xd8, 0xd9, 0xda, 0xdb, 0xdc, 0xdd, 0xde, 0xdf,
        0xe0, 0xe1, 0xe2, 0xe3, 0xe4, 0xe5, 0xe6, 0xe7, 0xe8, 0xe9, 0xea, 0xeb, 0xec, 0xed, 0xee, 0xef,
        0xf0, 0xf1, 0xf2, 0xf3, 0xf4, 0xf5, 0xf6, 0xf7, 0xf8, 0xf9, 0xfa, 0xfb, 0xfc, 0xfd, 0xfe, 0xff,
    },
    .aufType =
    {
        0x00802000, 0x00802000, 0x00802000, 0x00802000, 0x00802000, 0x00802000, 0x00802000, 0x00802000,
        0x00802000, 0x00806800, 0x00802800, 0x00802800, 0x00802800, 0x00802800, 0x00802000, 0x00802000,
        0x00802000, 0x00802000, 0x00802000, 0x00802000, 0x00802000, 0x00802000, 0x00802000, 0x00802000,
        0x00802000, 0x00802000, 0x00802000, 0x00802000, 0x00802000, 0x00802000, 0x00802000, 0x00802000,
        0x00884800, 0x008c1000, 0x008c1000, 0x008c1000, 0x00ac1000, 0x008c1000, 0x008c1000, 0x008c1000,
        0x008c1000, 0x008c1000, 0x008c1000, 0x00ac1000, 0x008c1000, 0x008c1000, 0x008c1000, 0x008c1000,
        0x009e8400, 0x009e8401, 0x009e8402, 0x009e8403, 0x009e8404, 0x009e8405, 0x009e8406, 0x009e8407,
        0x009e8408, 0x009e8409, 0x008c1000, 0x008c1000, 0x00ac1000, 0x00ac1000, 0x00ac1000, 0x008c1000,
        0x008c1000, 0x008f810a, 0x008f810b, 0x008f810c, 0x008f810d, 0x008f810e, 0x008f810f, 0x008f0100,
        0x008f0100, 0x008f0100, 0x008f0100, 0x008f0100, 0x008f0100, 0x008f0100, 0x008f0100, 0x008f0100,
        0x008f0100, 0x008f0100, 0x008f0100, 0x008f0100, 0x008f0100, 0x008f0100, 0x008f0100, 0x008f0100,
        0x008f0100, 0x008f0100, 0x008f0100, 0x008c1000, 0x008c1000, 0x008c1000, 0x00ac1000, 0x008c1000,
        0x00ac1000, 0x008f820a, 0x008f820b, 0x008f820c, 0x008f820d, 0x008f820e, 0x008f820f, 0x008f0200,
        0x008f0200, 0x008f0200, 0x008f0200, 0x008f0200, 0x008f0200, 0x008f0200, 0x008f0200, 0x008f0200,
        0x008f0200, 0x008f0200, 0x008f0200, 0x008f0200, 0x008f0200, 0x008f0200, 0x008f0200, 0x008f0200,
        0x008f0200, 0x008f0200, 0x008f0200, 0x008c1000, 0x00ac1000, 0x008c1000, 0x00ac1000, 0x00802000,
    },
    .au2MBCSPrefixs =
    {
        0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55,
        0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55,
        0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55,
        0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55,
    },
    .aucUnicode =
    {
        0x0000, 0x0001, 0x0002, 0x0003, 0x0004, 0x0005, 0x0006, 0x0007,
        0x0008, 0x0009, 0x000a, 0x000b, 0x000c, 0x000d, 0x000e, 0x000f,
        0x0010, 0x0011, 0x0012, 0x0013, 0x0014, 0x0015, 0x0016, 0x0017,
        0x0018, 0x0019, 0x001a, 0x001b, 0x001c, 0x001d, 0x001e, 0x001f,
        0x0020, 0x0021, 0x0022, 0x0023, 0x0024, 0x0025, 0x0026, 0x0027,
        0x0028, 0x0029, 0x002a, 0x002b, 0x002c, 0x002d, 0x002e, 0x002f,
        0x0030, 0x0031, 0x0032, 0x0033, 0x0034, 0x0035, 0x0036, 0x0037,
        0x0038, 0x0039, 0x003a, 0x003b, 0x003c, 0x003d, 0x003e, 0x003f,
        0x0040, 0x0041, 0x0042, 0x0043, 0x0044, 0x0045, 0x0046, 0x0047,
        0x0048, 0x0049, 0x004a, 0x004b, 0x004c, 0x004d, 0x004e, 0x004f,
        0x0050, 0x0051, 0x0052, 0x0053, 0x0054, 0x0055, 0x0056, 0x0057,
        0x0058, 0x0059, 0x005a, 0x005b, 0x005c, 0x005d, 0x005e, 0x005f,
        0x0060, 0x0061, 0x0062, 0x0063, 0x0064, 0x0065, 0x0066, 0x0067,
        0x0068, 0x0069, 0x006a, 0x006b, 0x006c, 0x006d, 0x006e, 0x006f,
        0x0070, 0x0071, 0x0072, 0x0073, 0x0074, 0x0075, 0x0076, 0x0077,
        0x0078, 0x0079, 0x007a, 0x007b, 0x007c, 0x007d, 0x007e, 0x007f,
        0x0080, 0x0081, 0x0082, 0x0083, 0x0084, 0x0085, 0x0086, 0x0087,
        0x0088, 0x0089, 0x008a, 0x008b, 0x008c, 0x008d, 0x008e, 0x008f,
        0x0090, 0x0091, 0x0092, 0x0093, 0x0094, 0x0095, 0x0096, 0x0097,
        0x0098, 0x0099, 0x009a, 0x009b, 0x009c, 0x009d, 0x009e, 0x009f,
        0x00a0, 0x00a1, 0x00a2, 0x00a3, 0x00a4, 0x00a5, 0x00a6, 0x00a7,
        0x00a8, 0x00a9, 0x00aa, 0x00ab, 0x00ac, 0x00ad, 0x00ae, 0x00af,
        0x00b0, 0x00b1, 0x00b2, 0x00b3, 0x00b4, 0x00b5, 0x00b6, 0x00b7,
        0x00b8, 0x00b9, 0x00ba, 0x00bb, 0x00bc, 0x00bd, 0x00be, 0x00bf,
        0x00c0, 0x00c1, 0x00c2, 0x00c3, 0x00c4, 0x00c5, 0x00c6, 0x00c7,
        0x00c8, 0x00c9, 0x00ca, 0x00cb, 0x00cc, 0x00cd, 0x00ce, 0x00cf,
        0x00d0, 0x00d1, 0x00d2, 0x00d3, 0x00d4, 0x00d5, 0x00d6, 0x00d7,
        0x00d8, 0x00d9, 0x00da, 0x00db, 0x00dc, 0x00dd, 0x00de, 0x00df,
        0x00e0, 0x00e1, 0x00e2, 0x00e3, 0x00e4, 0x00e5, 0x00e6, 0x00e7,
        0x00e8, 0x00e9, 0x00ea, 0x00eb, 0x00ec, 0x00ed, 0x00ee, 0x00ef,
        0x00f0, 0x00f1, 0x00f2, 0x00f3, 0x00f4, 0x00f5, 0x00f6, 0x00f7,
        0x00f8, 0x00f9, 0x00fa, 0x00fb, 0x00fc, 0x00fd, 0x00fe, 0x00ff,
    },
    .auchToSBCS0To128 =
    {
        0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f,
        0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17, 0x18, 0x19, 0x1a, 0x1b, 0x1c, 0x1d, 0x1e, 0x1f,
        0x20, 0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27, 0x28, 0x29, 0x2a, 0x2b, 0x2c, 0x2d, 0x2e, 0x2f,
        0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x3a, 0x3b, 0x3c, 0x3d, 0x3e, 0x3f,
        0x40, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47, 0x48, 0x49, 0x4a, 0x4b, 0x4c, 0x4d, 0x4e, 0x4f,
        0x50, 0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x57, 0x58, 0x59, 0x5a, 0x5b, 0x5c, 0x5d, 0x5e, 0x5f,
        0x60, 0x61, 0x62, 0x63, 0x64, 0x65, 0x66, 0x67, 0x68, 0x69, 0x6a, 0x6b, 0x6c, 0x6d, 0x6e, 0x6f,
        0x70, 0x71, 0x72, 0x73, 0x74, 0x75, 0x76, 0x77, 0x78, 0x79, 0x7a, 0x7b, 0x7c, 0x7d, 0x7e, 0x7f,
    },
    .cSBCSs = 5,
    .aSBCSs[0] =
    {
        .usStart = 0x0080,
        .cChars = 28,
        .auch =
        {

        0x80, 0x81, 0x82, 0x83, 0x84, 0x85, 0x86, 0x87, 0x88, 0x89, 0x8a, 0x8b, 0x8c, 0x8d, 0x8e, 0x8f,
        0x90, 0x91, 0x92, 0x93, 0x94, 0x95, 0x96, 0x97, 0x98, 0x99, 0x9a, 0x9b,
        }
    },
    .aSBCSs[1] =
    {
        .usStart = 0x009c,
        .cChars = 28,
        .auch =
        {

        0x9c, 0x9d, 0x9e, 0x9f, 0xa0, 0xa1, 0xa2, 0xa3, 0xa4, 0xa5, 0xa6, 0xa7, 0xa8, 0xa9, 0xaa, 0xab,
        0xac, 0xad, 0xae, 0xaf, 0xb0, 0xb1, 0xb2, 0xb3, 0xb4, 0xb5, 0xb6, 0xb7,
        }
    },
    .aSBCSs[2] =
    {
        .usStart = 0x00b8,
        .cChars = 28,
        .auch =
        {

        0xb8, 0xb9, 0xba, 0xbb, 0xbc, 0xbd, 0xbe, 0xbf, 0xc0, 0xc1, 0xc2, 0xc3, 0xc4, 0xc5, 0xc6, 0xc7,
        0xc8, 0xc9, 0xca, 0xcb, 0xcc, 0xcd, 0xce, 0xcf, 0xd0, 0xd1, 0xd2, 0xd3,
        }
    },
    .aSBCSs[3] =
    {
        .usStart = 0x00d4,
        .cChars = 28,
        .auch =
        {

        0xd4, 0xd5, 0xd6, 0xd7, 0xd8, 0xd9, 0xda, 0xdb, 0xdc, 0xdd, 0xde, 0xdf, 0xe0, 0xe1, 0xe2, 0xe3,
        0xe4, 0xe5, 0xe6, 0xe7, 0xe8, 0xe9, 0xea, 0xeb, 0xec, 0xed, 0xee, 0xef,
        }
    },
    .aSBCSs[4] =
    {
        .usStart = 0x00f0,
        .cChars = 16,
        .auch =
        {

        0xf0, 0xf1, 0xf2, 0xf3, 0xf4, 0xf5, 0xf6, 0xf7, 0xf8, 0xf9, 0xfa, 0xfb, 0xfc, 0xfd, 0xfe, 0xff,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        }
    },
    .CtypeFuncs =
    {
        .pfnmbsinit    =  __libc_locale_none_mbsinit,
        .pfnmbrtowc    =  __libc_locale_none_mbrtowc,
        .pfnmbsnrtowcs =  __libc_locale_none_mbsnrtowcs,
        .pfnwcrtomb    =  __libc_locale_none_wcrtomb,
        .pfnwcsnrtombs =  __libc_locale_none_wcsnrtombs
    },
    .uobj = 0,
    .lobj = 0,
    .mbcs = 0,
    .szCodeSet = "US-ASCII"
};


unsigned __ctype(__ct_rune_t __ch, unsigned __f)
{
    return !((__ch) & ~0xffU)
        ? __libc_GLocaleCtype.aufType[(__ch)/* & 0xff*/] & (__f)
        : 0;
}

int __istype(__ct_rune_t __ch, unsigned __f)
{
    return !!__ctype((__ch), (__f));
}

__ct_rune_t __toupper(__ct_rune_t __ch)
{
    return !((__ch) & ~0xffU)
        ? __libc_GLocaleCtype.auchUpper[(__ch)/* & 0xff*/]
        : (__ch);
}

__ct_rune_t __tolower(__ct_rune_t __ch)
{
    return !((__ch) & ~0xffU)
        ? __libc_GLocaleCtype.auchLower[(__ch)/* & 0xff*/]
        : (__ch);
}



/** Cached Unicode (__wchar_t) case conversion tables and flags. */
__LIBC_LOCALEWCTYPE    __libc_GLocaleWCtype =
{
    .awcLower =
    {
        0x0000, 0x0001, 0x0002, 0x0003, 0x0004, 0x0005, 0x0006, 0x0007,
        0x0008, 0x0009, 0x000a, 0x000b, 0x000c, 0x000d, 0x000e, 0x000f,
        0x0010, 0x0011, 0x0012, 0x0013, 0x0014, 0x0015, 0x0016, 0x0017,
        0x0018, 0x0019, 0x001a, 0x001b, 0x001c, 0x001d, 0x001e, 0x001f,
        0x0020, 0x0021, 0x0022, 0x0023, 0x0024, 0x0025, 0x0026, 0x0027,
        0x0028, 0x0029, 0x002a, 0x002b, 0x002c, 0x002d, 0x002e, 0x002f,
        0x0030, 0x0031, 0x0032, 0x0033, 0x0034, 0x0035, 0x0036, 0x0037,
        0x0038, 0x0039, 0x003a, 0x003b, 0x003c, 0x003d, 0x003e, 0x003f,
        0x0040, 0x0061, 0x0062, 0x0063, 0x0064, 0x0065, 0x0066, 0x0067,
        0x0068, 0x0069, 0x006a, 0x006b, 0x006c, 0x006d, 0x006e, 0x006f,
        0x0070, 0x0071, 0x0072, 0x0073, 0x0074, 0x0075, 0x0076, 0x0077,
        0x0078, 0x0079, 0x007a, 0x005b, 0x005c, 0x005d, 0x005e, 0x005f,
        0x0060, 0x0061, 0x0062, 0x0063, 0x0064, 0x0065, 0x0066, 0x0067,
        0x0068, 0x0069, 0x006a, 0x006b, 0x006c, 0x006d, 0x006e, 0x006f,
        0x0070, 0x0071, 0x0072, 0x0073, 0x0074, 0x0075, 0x0076, 0x0077,
        0x0078, 0x0079, 0x007a, 0x007b, 0x007c, 0x007d, 0x007e, 0x007f,
        0x0080, 0x0081, 0x0082, 0x0083, 0x0084, 0x0085, 0x0086, 0x0087,
        0x0088, 0x0089, 0x008a, 0x008b, 0x008c, 0x008d, 0x008e, 0x008f,
        0x0090, 0x0091, 0x0092, 0x0093, 0x0094, 0x0095, 0x0096, 0x0097,
        0x0098, 0x0099, 0x009a, 0x009b, 0x009c, 0x009d, 0x009e, 0x009f,
        0x00a0, 0x00a1, 0x00a2, 0x00a3, 0x00a4, 0x00a5, 0x00a6, 0x00a7,
        0x00a8, 0x00a9, 0x00aa, 0x00ab, 0x00ac, 0x00ad, 0x00ae, 0x00af,
        0x00b0, 0x00b1, 0x00b2, 0x00b3, 0x00b4, 0x00b5, 0x00b6, 0x00b7,
        0x00b8, 0x00b9, 0x00ba, 0x00bb, 0x00bc, 0x00bd, 0x00be, 0x00bf,
        0x00e0, 0x00e1, 0x00e2, 0x00e3, 0x00e4, 0x00e5, 0x00e6, 0x00e7,
        0x00e8, 0x00e9, 0x00ea, 0x00eb, 0x00ec, 0x00ed, 0x00ee, 0x00ef,
        0x00f0, 0x00f1, 0x00f2, 0x00f3, 0x00f4, 0x00f5, 0x00f6, 0x00d7,
        0x00f8, 0x00f9, 0x00fa, 0x00fb, 0x00fc, 0x00fd, 0x00fe, 0x00df,
        0x00e0, 0x00e1, 0x00e2, 0x00e3, 0x00e4, 0x00e5, 0x00e6, 0x00e7,
        0x00e8, 0x00e9, 0x00ea, 0x00eb, 0x00ec, 0x00ed, 0x00ee, 0x00ef,
        0x00f0, 0x00f1, 0x00f2, 0x00f3, 0x00f4, 0x00f5, 0x00f6, 0x00f7,
        0x00f8, 0x00f9, 0x00fa, 0x00fb, 0x00fc, 0x00fd, 0x00fe, 0x00ff,
    },
    .awcUpper =
    {
        0x0000, 0x0001, 0x0002, 0x0003, 0x0004, 0x0005, 0x0006, 0x0007,
        0x0008, 0x0009, 0x000a, 0x000b, 0x000c, 0x000d, 0x000e, 0x000f,
        0x0010, 0x0011, 0x0012, 0x0013, 0x0014, 0x0015, 0x0016, 0x0017,
        0x0018, 0x0019, 0x001a, 0x001b, 0x001c, 0x001d, 0x001e, 0x001f,
        0x0020, 0x0021, 0x0022, 0x0023, 0x0024, 0x0025, 0x0026, 0x0027,
        0x0028, 0x0029, 0x002a, 0x002b, 0x002c, 0x002d, 0x002e, 0x002f,
        0x0030, 0x0031, 0x0032, 0x0033, 0x0034, 0x0035, 0x0036, 0x0037,
        0x0038, 0x0039, 0x003a, 0x003b, 0x003c, 0x003d, 0x003e, 0x003f,
        0x0040, 0x0041, 0x0042, 0x0043, 0x0044, 0x0045, 0x0046, 0x0047,
        0x0048, 0x0049, 0x004a, 0x004b, 0x004c, 0x004d, 0x004e, 0x004f,
        0x0050, 0x0051, 0x0052, 0x0053, 0x0054, 0x0055, 0x0056, 0x0057,
        0x0058, 0x0059, 0x005a, 0x005b, 0x005c, 0x005d, 0x005e, 0x005f,
        0x0060, 0x0041, 0x0042, 0x0043, 0x0044, 0x0045, 0x0046, 0x0047,
        0x0048, 0x0049, 0x004a, 0x004b, 0x004c, 0x004d, 0x004e, 0x004f,
        0x0050, 0x0051, 0x0052, 0x0053, 0x0054, 0x0055, 0x0056, 0x0057,
        0x0058, 0x0059, 0x005a, 0x007b, 0x007c, 0x007d, 0x007e, 0x007f,
        0x0080, 0x0081, 0x0082, 0x0083, 0x0084, 0x0085, 0x0086, 0x0087,
        0x0088, 0x0089, 0x008a, 0x008b, 0x008c, 0x008d, 0x008e, 0x008f,
        0x0090, 0x0091, 0x0092, 0x0093, 0x0094, 0x0095, 0x0096, 0x0097,
        0x0098, 0x0099, 0x009a, 0x009b, 0x009c, 0x009d, 0x009e, 0x009f,
        0x00a0, 0x00a1, 0x00a2, 0x00a3, 0x00a4, 0x00a5, 0x00a6, 0x00a7,
        0x00a8, 0x00a9, 0x00aa, 0x00ab, 0x00ac, 0x00ad, 0x00ae, 0x00af,
        0x00b0, 0x00b1, 0x00b2, 0x00b3, 0x00b4, 0x00b5, 0x00b6, 0x00b7,
        0x00b8, 0x00b9, 0x00ba, 0x00bb, 0x00bc, 0x00bd, 0x00be, 0x00bf,
        0x00c0, 0x00c1, 0x00c2, 0x00c3, 0x00c4, 0x00c5, 0x00c6, 0x00c7,
        0x00c8, 0x00c9, 0x00ca, 0x00cb, 0x00cc, 0x00cd, 0x00ce, 0x00cf,
        0x00d0, 0x00d1, 0x00d2, 0x00d3, 0x00d4, 0x00d5, 0x00d6, 0x00d7,
        0x00d8, 0x00d9, 0x00da, 0x00db, 0x00dc, 0x00dd, 0x00de, 0x00df,
        0x00c0, 0x00c1, 0x00c2, 0x00c3, 0x00c4, 0x00c5, 0x00c6, 0x00c7,
        0x00c8, 0x00c9, 0x00ca, 0x00cb, 0x00cc, 0x00cd, 0x00ce, 0x00cf,
        0x00d0, 0x00d1, 0x00d2, 0x00d3, 0x00d4, 0x00d5, 0x00d6, 0x00f7,
        0x00d8, 0x00d9, 0x00da, 0x00db, 0x00dc, 0x00dd, 0x00de, 0x0178,
    },
    .aufType =
    {

        0x00802000, 0x00802000, 0x00802000, 0x00802000, 0x00802000, 0x00802000, 0x00802000, 0x00802000,
        0x00802000, 0x00806800, 0x00802800, 0x00802800, 0x00802800, 0x00802800, 0x00802000, 0x00802000,
        0x00802000, 0x00802000, 0x00802000, 0x00802000, 0x00802000, 0x00802000, 0x00802000, 0x00802000,
        0x00802000, 0x00802000, 0x00802000, 0x00802000, 0x00802000, 0x00802000, 0x00802000, 0x00802000,
        0x00884800, 0x008c1000, 0x008c1000, 0x008c1000, 0x00ac1000, 0x008c1000, 0x008c1000, 0x008c1000,
        0x008c1000, 0x008c1000, 0x008c1000, 0x00ac1000, 0x008c1000, 0x008c1000, 0x008c1000, 0x008c1000,
        0x009e8400, 0x009e8401, 0x009e8402, 0x009e8403, 0x009e8404, 0x009e8405, 0x009e8406, 0x009e8407,
        0x009e8408, 0x009e8409, 0x008c1000, 0x008c1000, 0x00ac1000, 0x00ac1000, 0x00ac1000, 0x008c1000,
        0x008c1000, 0x008f810a, 0x008f810b, 0x008f810c, 0x008f810d, 0x008f810e, 0x008f810f, 0x008f0100,
        0x008f0100, 0x008f0100, 0x008f0100, 0x008f0100, 0x008f0100, 0x008f0100, 0x008f0100, 0x008f0100,
        0x008f0100, 0x008f0100, 0x008f0100, 0x008f0100, 0x008f0100, 0x008f0100, 0x008f0100, 0x008f0100,
        0x008f0100, 0x008f0100, 0x008f0100, 0x008c1000, 0x008c1000, 0x008c1000, 0x00ac1000, 0x008c1000,
        0x00ac1000, 0x008f820a, 0x008f820b, 0x008f820c, 0x008f820d, 0x008f820e, 0x008f820f, 0x008f0200,
        0x008f0200, 0x008f0200, 0x008f0200, 0x008f0200, 0x008f0200, 0x008f0200, 0x008f0200, 0x008f0200,
        0x008f0200, 0x008f0200, 0x008f0200, 0x008f0200, 0x008f0200, 0x008f0200, 0x008f0200, 0x008f0200,
        0x008f0200, 0x008f0200, 0x008f0200, 0x008c1000, 0x00ac1000, 0x008c1000, 0x00ac1000, 0x00802000,
        0x00802000, 0x00802000, 0x00802000, 0x00802000, 0x00802000, 0x00802000, 0x00802000, 0x00802000,
        0x00802000, 0x00802000, 0x00802000, 0x00802000, 0x00802000, 0x00802000, 0x00802000, 0x00802000,
        0x00802000, 0x00802000, 0x00802000, 0x00802000, 0x00802000, 0x00802000, 0x00802000, 0x00802000,
        0x00802000, 0x00802000, 0x00802000, 0x00802000, 0x00802000, 0x00802000, 0x00802000, 0x00802000,
        0x002c1000, 0x000c1000, 0x002c1000, 0x002c1000, 0x002c1000, 0x002c1000, 0x002c1000, 0x002c1000,
        0x002c1000, 0x002c1000, 0x000f0200, 0x000c1000, 0x002c1000, 0x000c1000, 0x002c1000, 0x002c1000,
        0x002c1000, 0x002c1000, 0x002c1000, 0x002c1000, 0x002c1000, 0x000f0200, 0x002c1000, 0x000c1000,
        0x002c1000, 0x002c1000, 0x000f0200, 0x000c1000, 0x002c1000, 0x002c1000, 0x002c1000, 0x000c1000,
        0x000f0100, 0x000f0100, 0x000f0100, 0x000f0100, 0x000f0100, 0x000f0100, 0x000f0100, 0x000f0100,
        0x000f0100, 0x000f0100, 0x000f0100, 0x000f0100, 0x000f0100, 0x000f0100, 0x000f0100, 0x000f0100,
        0x000f0100, 0x000f0100, 0x000f0100, 0x000f0100, 0x000f0100, 0x000f0100, 0x000f0100, 0x002c1000,
        0x000f0100, 0x000f0100, 0x000f0100, 0x000f0100, 0x000f0100, 0x000f0100, 0x000f0100, 0x000f0200,
        0x000f0200, 0x000f0200, 0x000f0200, 0x000f0200, 0x000f0200, 0x000f0200, 0x000f0200, 0x000f0200,
        0x000f0200, 0x000f0200, 0x000f0200, 0x000f0200, 0x000f0200, 0x000f0200, 0x000f0200, 0x000f0200,
        0x000f0200, 0x000f0200, 0x000f0200, 0x000f0200, 0x000f0200, 0x000f0200, 0x000f0200, 0x002c1000,
        0x000f0200, 0x000f0200, 0x000f0200, 0x000f0200, 0x000f0200, 0x000f0200, 0x000f0200, 0x000f0200,
    },
    .uMask = ~0x7fU,
};


unsigned __wctype(__wint_t __wc, unsigned __f)
{
    return !(__wc & __libc_GLocaleWCtype.uMask)
        ? __libc_GLocaleWCtype.aufType[__wc] & __f
        : ___wctype(__wc) & __f;
}

int __iswtype(__wint_t __wc, unsigned __f)
{
    return !!__wctype(__wc, __f);
}

__wint_t __towupper(__wint_t __wc)
{
    return !(__wc & __libc_GLocaleWCtype.uMask)
        ? __libc_GLocaleWCtype.awcUpper[__wc]
        : ___towupper(__wc);
}

__wint_t __towlower(__wint_t __wc)
{
    return !(__wc & __libc_GLocaleWCtype.uMask)
        ? __libc_GLocaleWCtype.awcLower[__wc]
        : ___towlower(__wc);
}

int __wcwidth(__wint_t __wc)
{
    if (__wc != 0)
    {
        unsigned __f = __wctype(__wc, __CT_SCRW_MASK | __CT_PRINT);
        return (__f & __CT_SCRW_MASK)
            ? (__f & __CT_SCRW_MASK) >> __CT_SCRW_SHIFT
            : (__f & __CT_PRINT) ? 1 : -1;
    }
    return 0;
}


/**
 * Get unicode type.
 * ASSUMES that none of the locals differs from the unicode spec
 */
unsigned ___wctype(__wchar_t wc)
{
    unsigned    ufType = 0;
    if (    __libc_GLocaleWCtype.uMask != ~0x7f
        ||  wc <= 127)
    {
        UNICTYPE   *pUniType = UniQueryCharType(wc);
        if (pUniType)
        {
            /* ASSUMES CT_* << 8 == __* ! */
            ufType = ((unsigned)pUniType->itype << 8)
                   & (__CT_UPPER  | __CT_LOWER  | __CT_DIGIT | __CT_SPACE |
                      __CT_PUNCT  | __CT_CNTRL  | __CT_BLANK | __CT_XDIGIT |
                      __CT_ALPHA  | __CT_ALNUM  | __CT_GRAPH | __CT_PRINT |
                      __CT_NUMBER | __CT_SYMBOL | __CT_ASCII);
            if (pUniType->extend & C3_IDEOGRAPH)
                ufType |= __CT_IDEOGRAM;
            if (ufType & (__CT_XDIGIT | __CT_DIGIT))
            {
                if (     (unsigned)wc - 0x30U <= (0x39 - 0x30))
                    ufType |= (unsigned)wc - 0x30;
                else if ((unsigned)wc - 0x41U <= (0x46 - 0x41))
                    ufType |= (unsigned)wc - 0x41 + 0xa;
                else
                {
                    unsigned uVal = UniQueryNumericValue(wc);
                    if (!(uVal & ~0xffU))
                        ufType |= uVal;
                }
            }
            ufType |= (pUniType->bidi & 0xf << 24);

            /** @todo screen width. */
        }
    }
    return ufType;
}

/**
 * Fold char to lowercase.
 * ASSUMES that none of the locals differs from the unicode spec.
 */
__wchar_t ___towlower(__wchar_t wc)
{
    if (    __libc_GLocaleWCtype.uMask == ~0x7f
        &&  wc > 127)
        return wc;
    FS_VAR_SAVE_LOAD();
    UniChar ucRet = UniTolower(wc);
    FS_RESTORE();
    return ucRet;
}

/**
 * Fold char to lowercase.
 * ASSUMES that none of the locals differs from the unicode spec.
 */
__wchar_t ___towupper(__wchar_t wc)
{
    if (    __libc_GLocaleWCtype.uMask == ~0x7f
        &&  wc > 127)
        return wc;
    FS_VAR_SAVE_LOAD();
    UniChar ucRet = UniToupper(wc);
    FS_RESTORE();
    return ucRet;
}



#ifdef LOCALE_CTYPE_GEN /* code for regenerating that table - link staticly! */

#include <InnoTekLIBC/locale.h>
#include <stdio.h>

int main(int argc, char **argv)
{
    int i;
    const int iMax = argc != 2 ? 128 : 256;
    if (!setlocale(LC_CTYPE, argc == 2 ? argv[1] : "en_US")) /* We use this because the "C" depends on the generated data! */
    {
        printf("setlocale failed!\n");
        return 1;
    }

    printf("{\n"
           "    .auchUpper =\n"
           "    {");
    for (i = 0; i < sizeof(__libc_GLocaleCtype.auchUpper) / sizeof(__libc_GLocaleCtype.auchUpper[0]); i++)
    {
        if (i % 16)
            printf("0x%02x, ", i < iMax ? (int)__libc_GLocaleCtype.auchUpper[i] : i);
        else
            printf("\n        0x%02x, ", i < iMax ? (int)__libc_GLocaleCtype.auchUpper[i] : i);
    }
    printf("\n"
           "    },\n"
           "    .auchLower =\n"
           "    {");
    for (i = 0; i < sizeof(__libc_GLocaleCtype.auchLower) / sizeof(__libc_GLocaleCtype.auchLower[0]); i++)
    {
        if (i % 16)
            printf("0x%02x, ", i < iMax ? (int)__libc_GLocaleCtype.auchLower[i] : i);
        else
            printf("\n        0x%02x, ", i < iMax ? (int)__libc_GLocaleCtype.auchLower[i] : i);
    }
    printf("\n"
           "    },\n"
           "    .aufType = \n"
           "    {");
    for (i = 0; i < iMax; i++)
    {
        if (i % 8)
            printf("0x%08x, ", (int)__libc_GLocaleCtype.aufType[i]);
        else
            printf("\n        0x%08x, ", (int)__libc_GLocaleCtype.aufType[i]);
    }
    printf("\n");

    /* prefixed */
    printf("    },\n"
           "    .au2MBCSPrefixs =\n"
           "    {");
    for (i = 0; i < sizeof(__libc_GLocaleCtype.au2MBCSPrefixs) / sizeof(__libc_GLocaleCtype.au2MBCSPrefixs[0]); i++)
    {
        if (i % 16)
            printf("0x%02x, ", (int)__libc_GLocaleCtype.au2MBCSPrefixs[i]);
        else
            printf("\n        0x%02x, ", (int)__libc_GLocaleCtype.au2MBCSPrefixs[i]);
    }
    printf("\n"
           "    },\n");

    /* -> unicode translation */
    printf("    .aucUnicode =\n"
           "    {");
    for (i = 0; i < sizeof(__libc_GLocaleCtype.aucUnicode) / sizeof(__libc_GLocaleCtype.aucUnicode[0]); i++)
    {
        if (i % 8)
            printf("0x%04x, ", (int)__libc_GLocaleCtype.aucUnicode[i]);
        else
            printf("\n        0x%04x, ", (int)__libc_GLocaleCtype.aucUnicode[i]);
    }
    printf("\n"
           "    },\n");

    /* <- unicode translation */
    printf("    .auchToSBCS0To128 =\n"
           "    {");
    for (i = 0; i < sizeof(__libc_GLocaleCtype.auchToSBCS0To128) / sizeof(__libc_GLocaleCtype.auchToSBCS0To128[0]); i++)
    {
        if (i % 16)
            printf("0x%02x, ", (int)__libc_GLocaleCtype.auchToSBCS0To128[i]);
        else
            printf("\n        0x%02x, ", (int)__libc_GLocaleCtype.auchToSBCS0To128[i]);
    }
    printf("\n"
           "    },\n");

    printf("    .cSBCSs = %d,\n", __libc_GLocaleCtype.cSBCSs);
    int j;
    for (j = 0; j < __libc_GLocaleCtype.cSBCSs; j++)
    {
        printf("    .aSBCSs[%d] =\n"
               "    {\n"
               "        .usStart = 0x%04x,\n"
               "        .cChars = %d,\n"
               "        .auch =\n"
               "        {\n",
               j,
               __libc_GLocaleCtype.aSBCSs[j].usStart,
               __libc_GLocaleCtype.aSBCSs[j].cChars);
        for (i = 0; i < sizeof(__libc_GLocaleCtype.aSBCSs[j].auch) / sizeof(__libc_GLocaleCtype.aSBCSs[j].auch[0]); i++)
        {
            if (i % 16)
                printf("0x%02x, ", (int)__libc_GLocaleCtype.aSBCSs[j].auch[i]);
            else
                printf("\n        0x%02x, ", (int)__libc_GLocaleCtype.aSBCSs[j].auch[i]);
        }
        printf("\n"
               "        }\n"
               "    },\n");
    }

    /* the functions. */
    printf("    .CtypeFuncs =\n"
           "    {\n"
           "        .pfnmbsinit    =  __libc_locale_none_mbsinit,\n"
           "        .pfnmbrtowc    =  __libc_locale_none_mbrtowc,\n"
           "        .pfnmbsnrtowcs =  __libc_locale_none_mbsnrtowcs,\n"
           "        .pfnwcrtomb    =  __libc_locale_none_wcrtomb,\n"
           "        .pfnwcsnrtombs =  __libc_locale_none_wcsnrtombs\n"
           "    },\n");


    /* the rest */
    printf("    .uobj = 0,\n"
           "    .lobj = 0,\n"
           "    .mbcs = %d,\n"
           "    .szCodeSet = \"US-ASCII\"\n"
           "};\n"
           "\n"
           "\n"
           "\n",
           (int)__libc_GLocaleCtype.mbcs);


    /*
     * The unicode table.
     */
    printf("{\n");

    /* Lower */
    printf("    .awcLower =\n"
           "    {");
    for (i = 0; i < sizeof(__libc_GLocaleWCtype.awcLower) / sizeof(__libc_GLocaleWCtype.awcLower[0]); i++)
    {
        wchar_t wc = ___towlower(i);
        if (i % 8)
            printf("0x%04x, ", (int)wc);
        else
            printf("\n        0x%04x, ", (int)wc);
    }
    printf("\n"
           "    },\n");

    /* Upper */
    printf("    .awcUpper =\n"
           "    {");
    for (i = 0; i < sizeof(__libc_GLocaleWCtype.awcUpper) / sizeof(__libc_GLocaleWCtype.awcUpper[0]); i++)
    {
        wchar_t wc = ___towupper(i);
        if (i % 8)
            printf("0x%04x, ", (int)wc);
        else
            printf("\n        0x%04x, ", (int)wc);
    }
    printf("\n"
           "    },\n");

    /* Type */
    printf("    .aufType =\n"
           "    {");
    for (i = 0; i < sizeof(__libc_GLocaleWCtype.aufType) / sizeof(__libc_GLocaleWCtype.aufType[0]); i++)
    {
        unsigned ufType = ___wctype(i);
        if (i % 8)
            printf("0x%08x, ", ufType);
        else
            printf("\n        0x%08x, ", ufType);
    }
    printf("\n"
           "    },\n"
           "    .uMask = ~0x7f,\n");

    /* done */
    printf("};\n");

    return 0;
}

#endif
