/* $Id: fork-1.c 2055 2005-06-19 08:04:00Z bird $ */
/** @file
 *
 * Massive forking.
 *
 * Copyright (c) 2005 knut st. osmundsen <bird@anduin.net>
 *
 *
 * This file is part of kBuild.
 *
 * kBuild is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * kBuild is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with kBuild; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

/*******************************************************************************
*   Header Files                                                               *
*******************************************************************************/
#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <sys/wait.h>

int main(int argc, char **argv)
{
    int cChildren = 0;
    int cErrors = 0;
    int i;
    for (i = 0; i < 5000; i++)
    {
        int pid = fork();
        switch (pid)
        {
            case -1:
                printf("Error errno=%d %s\n", errno, strerror(errno));
                cErrors++;
                break;
            case 0:
                //printf("I'm child %#x i=%d.\n", getpid(), i);
                exit(0);
                break;

            default:
            {
                cChildren++;

                /* don't spawn for ever! */
                if (!(i % 25))
                {
                    usleep(1000); /* be kind to the host */
                    if (!(i % 100))
                        printf("forked %#x i=%d cChildren=%d\n", pid, i, cChildren);
                }

                if (i % 3)
                    break;

                /* reap */
                int iStatus = -1;
                pid_t pid;
                while ((pid = wait4(-1, &iStatus, WNOHANG, NULL)) > 0)
                {
                    if (cChildren > 0)
                        cChildren--;
                    else
                    {
                        printf("wtf!?! no children officially running, but pid=%d arrived!\n", pid);
                        cErrors++;
                    }
                    if (!WIFEXITED(iStatus) || WEXITSTATUS(iStatus))
                    {
                        printf("child %d -> iStatus=%#x\n", pid, iStatus);
                        cErrors++;
                    }
                }
                break;
            }
        }
    }

    /*
     * Wait for the rest of the children.
     */
    int cLoops = 30;
    while (cChildren > 0 && cLoops-- > 0)
    {
        usleep(32000);

        /* reap */
        int iStatus = -1;
        pid_t pid;
        while ((pid = wait4(-1, &iStatus, WNOHANG, NULL)) > 0)
        {
            if (cChildren > 0)
                cChildren--;
            else
            {
                printf("wtf!?! no children officially running, but pid=%d arrived!\n", pid);
                cErrors++;
            }
            if (!WIFEXITED(iStatus) || WEXITSTATUS(iStatus))
            {
                printf("child %d -> iStatus=%#x\n", pid, iStatus);
                cErrors++;
            }
        }
    }

    if (!cErrors)
        printf("fork-1: SUCCESS\n");
    else
        printf("fork-1: FAILURE - %d errors\n", cErrors);
    return !!cErrors;
}
