/*
    Application low-level initialization routine.

    Copyright (c) 1992-1998 by Eberhard Mattes
    Copyright (c) 2003 InnoTek Systemberatung GmbH

    This routine is called from crt0.o. It should parse
    argv and envp, initialize heap and do all other sorts
    of low-level initialization.
*/


/*******************************************************************************
*   Header Files                                                               *
*******************************************************************************/
#include "libc-alias.h"
#define INCL_DOS
#define INCL_DOSSIGNALS
#define INCL_FSMACROS
#include <os2emx.h>
#include <string.h>
#include <sys/builtin.h>
#include <sys/fmutex.h>
#include <emx/startup.h>
#include <emx/syscalls.h>
#include <emx/umalloc.h>
#include <alloca.h>
#include <InnoTekLIBC/thread.h>
#include <InnoTekLIBC/sharedpm.h>
#include <InnoTekLIBC/backend.h>
#include <InnoTekLIBC/FastInfoBlocks.h>
#define __LIBC_LOG_GROUP    __LIBC_LOG_GRP_INITTERM
#include <InnoTekLIBC/logstrict.h>
#include "b_signal.h"


/* All globals is to be defined in this object file. */
#define EXTERN
#define INIT(x) = x
#include "syscalls.h"


/*******************************************************************************
*   Internal Functions                                                         *
*******************************************************************************/
static int parse_args(const char *src, char **argv, char *pool);


/*******************************************************************************
*   Global Variables                                                           *
*******************************************************************************/
/** argument count found by parse_args(). */
static int argc;


/*******************************************************************************
*   Defined Constants And Macros                                               *
*******************************************************************************/
/** Helper macros for parse args
 * @{ */
#define PUTC(c) BEGIN ++arg_size; if (pool != NULL) *pool++ = (c); END
#define PUTV    BEGIN ++argc; if (argv != NULL) *argv++ = pool; END
#define WHITE(c) ((c) == ' ' || (c) == '\t')
/** @} */


/**
 * Parses the argument string passed in as src.
 *
 * @returns size of the processed arguments.
 * @param   src     Pointer two sequent zero terminated string containing
 *                  the arguments to be parsed.
 * @param   pool    Pointer to memory pool to put the arguments into.
 *                  NULL allowed.
 * @param   argv    Pointer to argument vector to put argument pointers in.
 *                  NULL allowed.
 * @ingroup startup
 */
static int parse_args(const char *src, char **argv, char *pool)
{
    int bs, quote;
    char *flag_ptr;
    int   arg_size;

    argc = 0; arg_size = 0;
    /* argv[0] */
    PUTC((char)_ARG_NONZERO);
    PUTV;
    for (;;)
    {
        PUTC(*src);
        if (*src == 0)
            break;
        ++src;
    }
    ++src;
    for (;;)
    {
        while (WHITE(*src))
            ++src;
        if (*src == 0)
            break;
        flag_ptr = pool;
        PUTC((char)_ARG_NONZERO);
        PUTV;
        bs = 0; quote = 0;
        for (;;)
        {
            if (!quote ? (*src == '"' || *src == '\'') : *src == quote)
            {
                while (bs >= 2)
                {
                    PUTC('\\');
                    bs -= 2;
                }
                if (bs & 1)
                    PUTC(*src);
                else
                {
                    quote = quote ? 0 : *src;
                    if (flag_ptr != NULL)
                        *flag_ptr |= _ARG_DQUOTE;
                }
                bs = 0;
            }
            else if (*src == '\\')
                ++bs;
            else
            {
                while (bs != 0)
                {
                    PUTC('\\');
                    --bs;
                }
                if (*src == 0 || (WHITE(*src) && !quote))
                    break;
                PUTC(*src);
            }
            ++src;
        }
        PUTC(0);
    }
    return arg_size;
}


/**
 * Does initialization for thread 1 before main() is called.
 *
 * This function doesn't return, but leaves its stack frame on the stack by some
 * magic done in sys/386/appinit.s. The top of the returned stack have a layout
 * as seen in struct stackframe below - start of struct is main() callframe.
 *
 * @param   fFlags  Bit 0: If set the application is open to put the default heap in high memory.
 *                         If clear the application veto against putting the default heap in high memory.
 *                  Bit 1: If set some of the unixness of LIBC is disabled.
 *                         If clear all unix like features are enabled.
 *                  Passed on to __init_dll().
 *
 * @ingroup startup
 */
void __init(int fFlags)
{
    /** top of stack unpon 'return' from this function. */
    struct stackframe
    {
        /** Argument count. */
        int                           argc;
        /** Pointer to argument vector. */
        char **                       argv;
        /** Pointer to environmet vector. */
        char **                       envp;
        /** Exception handler registration record (*_sys_xreg). */
        EXCEPTIONREGISTRATIONRECORD   ExcpRegRec;
        /** Argument vector. */
        char *                        apszArg[1];
        /** somewhere after this comes the string. */
    } * pStackFrame;
    int       rc;
    int       cb;

    /*
     * Do the common initialization in case we're linked statically.
     * Then end the heap voting.
     */
    if (__init_dll(fFlags, 0))
        goto failure;

    __libc_HeapEndVoting();

    /*
     * Copy command line arguments.
     *    Parse it to figure out the size.
     *    Allocate stack frame for args and more.
     *    Redo the parsing, but setup argv now.
     */
    cb = parse_args(fibGetCmdLine(), NULL, NULL);
    cb += (argc + 1) * sizeof (char *) + sizeof (struct stackframe);
    cb = (cb + 15) & ~15;
    pStackFrame = alloca(cb);
    if (!pStackFrame)
        goto failure;

    pStackFrame->envp = _org_environ;
    pStackFrame->argc = argc;
    pStackFrame->argv = &pStackFrame->apszArg[0];
    parse_args(fibGetCmdLine(), pStackFrame->argv, (char*)&pStackFrame->argv[argc + 1]);
    pStackFrame->argv[argc] = NULL;

    /*
     * Free the SPM inherit data.
     */
    __libc_spmInheritFree();

    /*
     * Install exception handler, 16-bit signal handler and set signal focus.
     */
    rc = __libc_back_signalInitExe(&pStackFrame->ExcpRegRec);
    if (rc)
        goto failure;

    /*
     * Mark the process as a completely inited LIBC process.
     */
    __libc_spmExeInited();

    /* Return to the program. */
    _sys_init_ret(pStackFrame);

failure:
    DosExit(EXIT_PROCESS, 255);
}

