/* $Id: b_fsNativeFileModeSet.c 1942 2005-05-01 07:37:14Z bird $ */
/** @file
 *
 * LIBC SYS Backend - internal [l]chmod.
 *
 * Copyright (c) 2005 knut st. osmundsen <bird@innotek.de>
 *
 *
 * This file is part of InnoTek LIBC.
 *
 * InnoTek LIBC is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * InnoTek LIBC is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with InnoTek LIBC; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */


/*******************************************************************************
*   Header Files                                                               *
*******************************************************************************/
#include "libc-alias.h"
#define INCL_BASE
#define INCL_FSMACROS
#include <os2emx.h>
#include "b_fs.h"
#include <string.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <stdlib.h>
#include <limits.h>
#include "syscalls.h"
#include <InnoTekLIBC/libc.h>
#define __LIBC_LOG_GROUP __LIBC_LOG_GRP_BACK_FS
#include <InnoTekLIBC/logstrict.h>


/**
 * Sets the file access mode of a native file.
 *
 * @returns 0 on success.
 * @returns Negative error code (errno.h) on failure.
 * @param   fh      Handle to file.
 * @param   Mode    The filemode.
 */
int __libc_back_fsNativeFileModeSet(const char *pszNativePath, mode_t Mode)
{
    LIBCLOG_ENTER("pszNativePath=%p:{%s} Mode=%#x\n", (void *)pszNativePath, pszNativePath, Mode);
    union
    {
        FILESTATUS4     fsts4;
        FILESTATUS4L    fsts4L;
    } info;
#if OFF_MAX > LONG_MAX
    int     fLarge = 0;
#endif
    FS_VAR();

    /*
     * Validate input, refusing named pipes.
     */
    if (    (pszNativePath[0] == '/' || pszNativePath[0] == '\\')
        &&  (pszNativePath[1] == 'p' || pszNativePath[1] == 'P')
        &&  (pszNativePath[2] == 'i' || pszNativePath[2] == 'I')
        &&  (pszNativePath[3] == 'p' || pszNativePath[3] == 'P')
        &&  (pszNativePath[4] == 'e' || pszNativePath[4] == 'E')
        &&  (pszNativePath[5] == '/' || pszNativePath[5] == '\\'))
        LIBCLOG_RETURN_INT(-ENOENT);

    /*
     * If potential device, then perform real check.
     * (Devices are subject to mode in POSIX.)
     */
    /** @todo copy device check from the path resolver. */

    /*
     * Get path info.
     */
    FS_SAVE_LOAD();
    int rc;
#if OFF_MAX > LONG_MAX
    if (__libc_gpfnDosOpenL)
    {
        rc = DosQueryPathInfo((PCSZ)pszNativePath, FIL_QUERYEASIZEL, &info, sizeof(info.fsts4L));
        fLarge = 1;
    }
    else
#endif
        rc = DosQueryPathInfo((PCSZ)pszNativePath, FIL_QUERYEASIZE, &info, sizeof(info.fsts4));
    /* Now, if the file is open in write mode, we cannot even get the EA size. stupid. */
    if (rc == ERROR_SHARING_VIOLATION)
    {
#if OFF_MAX > LONG_MAX
        if (__libc_gpfnDosOpenL)
        {
            rc = DosQueryPathInfo((PCSZ)pszNativePath, FIL_STANDARDL, &info, sizeof(info.fsts4L) - sizeof(info.fsts4L.cbList));
            fLarge = 1;
        }
        else
#endif
            rc = DosQueryPathInfo((PCSZ)pszNativePath, FIL_STANDARD, &info, sizeof(info.fsts4) - sizeof(info.fsts4.cbList));
        info.fsts4L.cbList = 0;
    }
    if (rc)
    {
        rc = -__libc_native2errno(rc);
        FS_RESTORE();
        LIBCLOG_RETURN_INT(rc);
    }

    /* If in unix mode we'll get the EAs (if any). */
    rc = -1;
    if (    !__libc_gfNoUnix
        && (fLarge ? info.fsts4L.cbList : info.fsts4.cbList) >= LIBC_UNIX_EA_MIN
        /*&&  __libc_back_fsUnixAttribsGet(-1, pszNativePath, pStat) == 0*/)
    {
        /* Update unix attributes. */
    }

    /*
     * Update OS/2 attributes.
     */
#if OFF_MAX > LONG_MAX
    if (fLarge)
    {
        if (Mode & S_IWRITE)
            info.fsts4L.attrFile &= ~FILE_READONLY;
        else
            info.fsts4L.attrFile = FILE_READONLY;
        rc = DosSetPathInfo((PCSZ)pszNativePath, FIL_STANDARDL, &info, sizeof(info.fsts4L) - sizeof(info.fsts4L.cbList), 0);
    }
    else
#endif
    {
        if (Mode & S_IWRITE)
            info.fsts4.attrFile &= ~FILE_READONLY;
        else
            info.fsts4.attrFile |= FILE_READONLY;
        rc = DosSetPathInfo((PCSZ)pszNativePath, FIL_STANDARD, &info, sizeof(info.fsts4) - sizeof(info.fsts4.cbList), 0);
    }

    FS_RESTORE();
    if (rc)
        rc = -__libc_native2errno(rc);
    LIBCLOG_RETURN_INT(rc);
}

