/* $Id: sysctl_os2.c 1919 2005-04-26 01:46:29Z bird $ */
/** @file
 *
 * LIBC - OS/2 specific sysctl stuff.
 *
 * Copyright (c) 2005 knut st. osmundsen <bird@anduin.net>
 *
 *
 * This file is part of InnoTek LIBC.
 *
 * InnoTek LIBC is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * InnoTek LIBC is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with InnoTek LIBC; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#include "libc-alias.h"

#define INCL_BASE
#define INCL_ERRORS
#include <os2.h>

#include <unistd.h>
#include <sys/types.h>
#include <sys/time.h>
#include <InnoTekLIBC/FastInfoBlocks.h>
#define _KERNEL
#include <sys/sysctl.h>


/**
 * System bootup time.
 */
static int sysctl_kern_boottime(SYSCTL_HANDLER_ARGS)
{
    static struct timeval tv;                  /* The boot time, only calc this once! */
    if (!tv.tv_sec)
    {
        union
        {
            QWORD  qw;
            unsigned long long ull;
        } u;
        ULONG ul;

        /* Try the highres timer first. */
        if (   !DosTmrQueryFreq(&ul)
            && !DosTmrQueryTime(&u.qw))
        {
            gettimeofday(&tv, NULL);
            tv.tv_sec -= u.ull / ul;
            long double lrd = u.ull;
            lrd *= 1000000;
            lrd /= ul;
            ul = (ULONG)lrd;
            tv.tv_usec -= ul % 1000000;
        }
        else
        {
            /* Use the millisecond counter. */
            gettimeofday(&tv, NULL);
            ul = fibGetMsCount();
            unsigned u = (ul % 1000) * 1000;
            tv.tv_usec -= u;
            tv.tv_sec -= ul / 1000;
        }
        if (tv.tv_usec < 0)
        {
            tv.tv_sec--;
            tv.tv_usec += 1000000;
        }
    }

    return (sysctl_handle_opaque(oidp, &tv, sizeof(tv), req));
}

SYSCTL_PROC(_kern, KERN_BOOTTIME, boottime, CTLFLAG_RD,
	0, 0, sysctl_kern_boottime, "S,timeval", "System boottime");

/**
 * System bootup time.
 */
static int sysctl_kern_bootfile(SYSCTL_HANDLER_ARGS)
{
    static char szBootFile[] = "?:/OS2KRNL";
    if (szBootFile[0] == '?')
        szBootFile[0] = __libc_GpFIBGIS->SIS_BootDrv + 'A' - 1;

    return (sysctl_handle_string(oidp, szBootFile, sizeof(szBootFile), req));
}

SYSCTL_PROC(_kern, KERN_BOOTFILE, bootfile, CTLFLAG_RD,
	0, 0, sysctl_kern_bootfile, "A", "Kernel file");

