/* - modified for gcc/os2 by bird 2003
 *
 * Copyright (c) 1982, 1986, 1993
 *	The Regents of the University of California.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	@(#)time.h	8.5 (Berkeley) 5/4/95
  */

#ifndef _SYS_TIME_H_
#define _SYS_TIME_H_

#include <time.h>
#include <sys/types.h>

#if defined (__cplusplus)
extern "C" {
#endif

#if !defined (_TIMEVAL)
#define _TIMEVAL
/** gettimeofday return structure */
struct timeval
{
  /** seconds */
  long tv_sec;
  /** and microseconds */
  long tv_usec;
};
#endif

#if !defined (_TIMEZONE)
#define _TIMEZONE
/** Timezone information */
struct timezone
{
  /** minutes west of Greenwich */
  int tz_minuteswest;
  /** type of dst correction. */
  int tz_dsttime;
};
#endif

#if !defined(TCPV40HDRS) && !defined(DST_NONE)
#define DST_NONE    0   /* not on dst */
#define DST_USA     1   /* USA style dst. */
#define DST_AUST    2   /* Australian style dst. */
#define DST_WET     3   /* Western European dst. */
#define DST_MET     4   /* Middle European dst. */
#define DST_EET     5   /* Eastern European dst. */
#define DST_CAN     6   /* Canada. */
#endif  /* !TCPV40HDRS */

#ifndef TCPV40HDRS
#pragma pack(4)
/** POSIX.4 version of timeval. */
struct timespec {
        time_t  ts_sec;         /* seconds */
        long    ts_nsec;        /* and nanoseconds */
};
#pragma pack()
#define TIMEVAL_TO_TIMESPEC(tv, ts) {                                   \
        (ts)->ts_sec = (tv)->tv_sec;                                    \
        (ts)->ts_nsec = (tv)->tv_usec * 1000;                           \
}
#define TIMESPEC_TO_TIMEVAL(tv, ts) {                                   \
        (tv)->tv_sec = (ts)->ts_sec;                                    \
        (tv)->tv_usec = (ts)->ts_nsec / 1000;                           \
}

/* Operations on timevals. */
#define timerclear(tvp)         ((tvp)->tv_sec = (tvp)->tv_usec = 0)
#define timerisset(tvp)         ((tvp)->tv_sec || (tvp)->tv_usec)
#ifndef timercmp
#define timercmp(tvp, uvp, cmp)                                         \
        (((tvp)->tv_sec == (uvp)->tv_sec) ?                             \
            ((tvp)->tv_usec cmp (uvp)->tv_usec) :                       \
            ((tvp)->tv_sec cmp (uvp)->tv_sec))
#endif
#ifndef timeradd
#define timeradd(tvp, uvp, vvp)						\
	do {								\
		(vvp)->tv_sec = (tvp)->tv_sec + (uvp)->tv_sec;		\
		(vvp)->tv_usec = (tvp)->tv_usec + (uvp)->tv_usec;	\
		if ((vvp)->tv_usec >= 1000000) {			\
			(vvp)->tv_sec++;				\
			(vvp)->tv_usec -= 1000000;			\
		}							\
	} while (0)
#endif
#ifdef timersub
#define timersub(tvp, uvp, vvp)						\
	do {								\
		(vvp)->tv_sec = (tvp)->tv_sec - (uvp)->tv_sec;		\
		(vvp)->tv_usec = (tvp)->tv_usec - (uvp)->tv_usec;	\
		if ((vvp)->tv_usec < 0) {				\
			(vvp)->tv_sec--;				\
			(vvp)->tv_usec += 1000000;			\
		}							\
	} while (0)
#endif

/*
 * Getkerninfo clock information structure
 */
struct clockinfo {
        int     hz;             /* clock frequency */
        int     tick;           /* micro-seconds per hz tick */
        int     stathz;         /* statistics clock frequency */
        int     profhz;         /* profiling clock frequency */
};

/*
 * Names of the interval timers, and structure
 * defining a timer setting.
 */
#define ITIMER_REAL     0
#define ITIMER_VIRTUAL  1
#define ITIMER_PROF     2
#endif /* !TCPV40HDRS */

#pragma pack(4)
struct  itimerval {
        struct  timeval it_interval;    /* timer interval */
        struct  timeval it_value;       /* current value */
};
#pragma pack()


#if defined(TCPV40HDRS) || !defined(_POSIX_SOURCE)
/** @name tcpip40 function mappings.
 * @{ */
/* utimes, gettimeofday and settimeofday is EMX so no mapping is needed. */
#define adjtime       tcpip40_adjtime
#define getitimer     tcpip40_getitimer
#define setitimer     tcpip40_setitimer
/* @} */
/* These are libc functions so no _System convention. */
int     utimes (__const__ char *, __const__ struct timeval *);
int     gettimeofday (struct timeval *, struct timezone *);
int     settimeofday (__const__ struct timeval *, __const__ struct timezone *);
#ifndef TCPV40HDRS
#include <sys/cdefs.h>
int     _System adjtime(const struct timeval *, struct timeval *);
int     _System getitimer(int, struct itimerval *);
int     _System setitimer(int, const struct itimerval *, struct itimerval *);
#endif
#endif /* TCPV40HDRS */


#if defined (__cplusplus)
}
#endif

#endif /* not _SYS_TIME_H_ */
