/* ioctl.c (emx+gcc) -- Copyright (c) 1990-1996 by Eberhard Mattes */

#include "libc-alias.h"
#include <stdlib.h>
#include <stdarg.h>
#include <fcntl.h>
#include <errno.h>
#include <sys/termio.h>
#include <sys/ioctl.h>
#include <emx/io.h>
#include <emx/syscalls.h>

/** Get the low word of the ioctl request number.
 * Used to support ioctl request numbers from old and new _IOC macros.
 */
#define __IOCLW(a) ((unsigned short)(a))


int _STD(ioctl) (int handle, unsigned long request, ...)
{
  va_list va;
  int rc, saved_errno, arg, *int_ptr, *pflags, *pla;
  const struct termio *tp;

  if ((pflags = _fd_flags (handle)) == NULL)
    {
      errno = EBADF;
      return -1;
    }
  saved_errno = errno; errno = 0;
  va_start (va, request);
  arg = va_arg (va, int);
  va_end (va);
  rc = __ioctl2 (handle, request, arg);
  if (rc >= 0 && errno == 0)
    switch (__IOCLW(request))
      {
      case __IOCLW(TCSETAF):
      case __IOCLW(TCSETAW):
      case __IOCLW(TCSETA):
        va_start (va, request);
        tp = va_arg (va, const struct termio *);
        va_end (va);
        if (tp->c_lflag & IDEFAULT)
          *pflags &= ~F_TERMIO;
        else
          *pflags |= F_TERMIO;
        break;

      case __IOCLW(_TCSANOW):
      case __IOCLW(_TCSADRAIN):
      case __IOCLW(_TCSAFLUSH):
        *pflags |= F_TERMIO;
        break;

      case __IOCLW(FIONREAD):
        if ((pla = _fd_lookahead (handle)) != NULL && *pla >= 0)
          {
            va_start (va, request);
            int_ptr = va_arg (va, int *);
            va_end (va);
            ++(*int_ptr);
          }
        break;

      case __IOCLW(FIONBIO):
        va_start (va, request);
        int_ptr = va_arg (va, int *);
        va_end (va);
        if (*int_ptr)
          *pflags |= O_NDELAY;
        else
          *pflags &= ~O_NDELAY;
        break;
      }
  if (errno == 0)
    errno = saved_errno;
  return rc;
}
