/* emx/gcc */
#ifndef _UTILS_H_
#define _UTILS_H_

#ifdef TCPV40HDRS

/** @name tcpip40 function mappings.
 * @{ */
#define lswap   tcpip40_lswap
#define bswap   tcpip40_bswap
#define rexec   tcpip40_rexec
/* @} */
unsigned long   _System lswap(unsigned long);
unsigned short  _System bswap(unsigned short);
int             _System rexec(char **, int, char *, char *, char *, int *);

/* Definition for bswap */
#ifndef htonl
#include <machine/endian.h>
#endif

#define ovbcopy(x,y,z)  bcopy((x),(y),(z))
#define copyout(x,y,z)  memcpy((y),(x),(z))
#ifndef XP_OS2_VACPP /* mozilla */
#define strcasecmp(x,y)     strcmpi((x),(y))
#define strncasecmp(x,y,z)  strnicmp(x,y,z)
#endif

#ifndef MIN
#define MIN(a,b) (((a)<(b))?(a):(b))
#define imin(x,y) MIN((x),(y))
#define MAX(a,b) (((a)>(b))?(a):(b))
#endif
#ifndef min
#define min(a,b) (((a)<(b))?(a):(b))
#endif
/* timercmp */
#include <sys/time.h>

#else
int     _System rexec(char **, int, char *, char *, char *, int *);
#endif /*TCPV40HDRS*/

#endif
