/* Copyright (c)1996 by Holger Veit
 * May be freely used with EMX
 * Modified 2003 by bird
 */

#ifndef _SYS_UN_H_
#define _SYS_UN_H_

/** Definitions for UNIX IPC domain. */
struct  sockaddr_un {
#ifdef TCPV40HDRS
	u_short	sun_family;	/* socket family: AF_UNIX */
#else
        u_char  sun_len;        /* sockaddr len including null */
        u_char  sun_family;     /* AF_UNIX */
#endif
	char	sun_path[108];	/* path name (not used) */
};

#ifndef TCPV40HDRS
/* actual length of an initialized sockaddr_un */
#define SUN_LEN(su) (sizeof(*(su)) - sizeof((su)->sun_path) + strlen((su)->sun_path))
#endif

#endif /* !_SYS_UN_H_ */
