#!/bin/sh
#
# $Id: gentestcase.sh 182 2003-05-19 02:17:30Z bird $
#
# Generate testcases for TCPIP headers.
#

# Constants.
sFiles=files.lst
fTCPv40=0
#todo must ignore defines for structure memebers and strings...
sSED_Defines="-e '/^[[:blank:]]*#[[:blank:]]*define[[:blank:]]*/!d' "
sSED_Defines="$sSED_Defines -e 's/^[[:blank:]]*#[[:blank:]]*define[[:blank:]]*\([a-zA-Z0-9_]*\).*/\1/'"
sSED_Structs="-e '/[[:blank:]]*struct[[:blank:]]*/!d' -e '/*/d' -e '/(/d' -e '/)/d'"
sSED_Structs="$sSED_Structs -e 's/.*struct[[:blank:]]*\([a-zA-Z0-9_]*\).*/\1/'"


# Check arguments.
if [ -z "$2" ]; then
    echo "syntax: gentestcase.sh <includedir> <outputfile> [tcpv4hdrs]";
    exit 1;
fi
sIncDir=$1
sOutFile=$2
if [ ! -z "$3" ]; then
    fTCPv40=1;
fi


# file header
echo "/* autogenerated." > $sOutFile
echo " * commandline: $*" >> $sOutFile
echo " */" >> $sOutFile
echo "" >> $sOutFile
echo "" >> $sOutFile

# include the headers.
echo "/*******************************************************************************" >> $sOutFile
echo "*   Header Files                                                               *" >> $sOutFile
echo "*******************************************************************************/" >> $sOutFile
if [ $fTCPv40 = 1 ]; then
    echo "#define TCPV40HDRS" >> $sOutFile
    echo "#define OS2" >> $sOutFile
fi
for sFile in `cat $sFiles`;
do
    if [ -f $sIncDir/$sFile ]; then
        echo "#include <$sFile>" >> $sOutFile
    else
        echo "/* file not found: #include <$sFile> */" >> $sOutFile
    fi
done
echo "" >> $sOutFile
echo "" >> $sOutFile



# testcase template
echo "/* test */" > tmpdeftst-template.c
if [ $fTCPv40 = 1 ]; then
    echo "#define TCPV40HDRS" >> tmpdeftst-template.c
    echo "#define OS2" >> tmpdeftst-template.c
fi
for sFile in `cat $sFiles`;
do
    if [ -f $sIncDir/$sFile ]; then
        echo "#include <$sFile>" >> tmpdeftst-template.c
    fi
done
#icc -q  -Pe -Pd -W0 -I$sIncDir tmpdeftst-template-tmp.c > tmpdeftst-template.c


# generate define printer
echo "/**" >> $sOutFile
echo " * Print the value of all defines we find to stdout." >> $sOutFile
echo " */" >> $sOutFile
echo "void printDefines(void)" >> $sOutFile
echo "{" >> $sOutFile
echo "    printf(\"\\n\\nDefines:\\n\");" >> $sOutFile
for sFile in `cat $sFiles`;
do
    if [ -f $sIncDir/$sFile ]; then
        echo "    /* defines from $sFile ($sIncDir/$sFile) */" >> $sOutFile
        for sDefine in `sh -c "sed $sSED_Defines $sIncDir/$sFile"`;
        do
            echo "    #ifdef $sDefine" >> $sOutFile
            cp -f tmpdeftst-template.c tmpdeftst.c
            echo "int main(int argc, char **argv) { int rc = (int)($sDefine); return rc; }" >> tmpdeftst.c
            if icc -c -Ss -q -W1 -Si tmpdeftst.c; then
                echo "    printf(\"    %42s: %3d\\n\", \"$sDefine\", (int)($sDefine));" >> $sOutFile
            else
                #cp -f tmpdeftst-template.c tmpdeftst.c
                #echo "int main(int argc, char **argv) { int rc = (int)($sDefine(42)); return rc; }" >> tmpdeftst.c
                #if icc -q -Ss -W1 -Si tmpdeftst.c; then
                #    echo "    printf(\"    %42s: %3d\\n\", \"$sDefine\", (int)($sDefine(42)));" >> $sOutFile
                #else
                    echo "    printf(\"    %42s\\n\", \"$sDefine\");" >> $sOutFile
                #fi
            fi
            echo "    #endif" >> $sOutFile
        done
    fi
done
echo "}" >> $sOutFile
echo "" >> $sOutFile
echo "" >> $sOutFile



# generate structure printer
echo "/**" >> $sOutFile
echo " * Print the size of structures we find to stdout." >> $sOutFile
echo " */" >> $sOutFile
echo "void printStructures(void)" >> $sOutFile
echo "{" >> $sOutFile
echo "    printf(\"\\n\\nStructures:\\n\");" >> $sOutFile
for sFile in `cat $sFiles`;
do
    if [ -f $sIncDir/$sFile ]; then
        echo "    /* structures from $sFile ($sIncDir/$sFile) */" >> $sOutFile
        for sStruct in `sh -c "sed $sSED_Structs $sIncDir/$sFile"`;
        do
            echo "    printf(\"  %42s: %3d\\n\", \"$sStruct\", sizeof(struct $sStruct));" >> $sOutFile
        done
    fi
done
echo "}" >> $sOutFile
echo "" >> $sOutFile
echo "" >> $sOutFile




# generate main function
echo "/**" >> $sOutFile
echo " * Main." >> $sOutFile
echo " */" >> $sOutFile
echo "int main(int argc, char **argv)" >> $sOutFile
echo "{" >> $sOutFile
echo "     printDefines();" >> $sOutFile
echo "     printStructures();" >> $sOutFile
echo "     return 0;" >> $sOutFile
echo "}" >> $sOutFile

