/* sys/signal.c (emx+gcc) -- Copyright (c) 1992-1996 by Eberhard Mattes */

#define INCL_DOSEXCEPTIONS
#include <os2emx.h>
#include <errno.h>
#include <emx/syscalls.h>
#include "syscalls.h"

typedef void sigfun (int sig);

sigfun *__signal (int sig, sigfun *handler)
{
  if (handler == SIG_ACK)
    {
      thread_data *tp;

      if (sig < 1 || sig >= NSIG || sig == SIGKILL || !_sys_sig_valid[sig])
        {
          errno = EINVAL;
          return SIG_ERR;
        }
      tp = SYS_THREAD;
      if (tp == NULL)
        return SIG_ERR;
      __sigdelset (&tp->sig_blocked, sig);
      _sys_deliver_pending_signals (tp);
      return tp->signals[sig].sa_handler;
    }
  else
    {
      struct sigaction isa, osa;

      isa.sa_handler = handler;
      isa.sa_mask = 0;
      isa.sa_flags = SA_ACK;
      if (__sigaction (sig, &isa, &osa) != 0)
        return SIG_ERR;
      else
        return osa.sa_handler;
    }
}
