/* sys/fcntl.c (emx+gcc) -- Copyright (c) 1992-1996 by Eberhard Mattes */

#include <fcntl.h>
#include <errno.h>
#include <os2emx.h>
#include <emx/syscalls.h>
#include "syscalls.h"

int __fcntl (int handle, int request, int arg)
{
  ULONG rc;
  ULONG state, new_state;

  switch (request)
    {
    case F_SETFL:
      return 0;
    case F_GETFD:
      rc = DosQueryFHState (handle, &state);
      if (rc != 0)
        {
          _sys_set_errno (rc);
          return -1;
        }
      return ((state & OPEN_FLAGS_NOINHERIT) ? 1 : 0);
    case F_SETFD:
      rc = DosQueryFHState (handle, &state);
      if (rc != 0)
        {
          _sys_set_errno (rc);
          return -1;
        }
      if (arg & 1)
        new_state = state | OPEN_FLAGS_NOINHERIT;
      else
        new_state = state & ~OPEN_FLAGS_NOINHERIT;
      if (new_state != state)
        {
          new_state &= 0x7f88;
          rc = DosSetFHState (handle, new_state);
          if (rc != 0)
            {
              _sys_set_errno (rc);
              return -1;
            }
        }
      return 0;
    default:
      errno = EINVAL;
      return -1;
    }
}
