/ crt0.s (emx+gcc) -- Copyright (c) 1990-1998 by Eberhard Mattes

        .globl  __text
        .globl  ___syscall
        .globl  __data
        .globl  __heap_base
        .globl  __heap_brk
        .globl  __heap_end
        .globl  __init

        .text

__text:
        push    $__data
#if defined (OMF)
        call    __emx_init
#else
        call    __dos_init
#endif
        jmp     __init

___syscall:
#if defined (OMF)
        call    __emx_syscall
#else
        call    __dos_syscall
#endif
        ret

        .space  6, 0x90                 /* Patch area for rsx */

__init: cld
        call    __entry1
        call    __entry2
#if defined (MCRT0)
        pushl   $__mcleanup
        call    _atexit
        addl    $4, %esp
        pushl   $__etext
        pushl   $__text
        call    _monstartup
        addl    $2*4, %esp
#endif
        call    __startup
        call    _main
        addl    $3*4, %esp
        pushl   %eax
        call    _exit
2:      jmp     2b

        .data

/ The data segment starts with a table containing the start and end
/ addresses of the text, data and bss segments

__data:
#if defined (OMF)
        .long   0
        .long   0
        .long   0
        .long   0
        .long   0
        .long   0
#else
        .long   __text
        .long   __etext
        .long   __data
        .long   __edata
        .long   __edata
        .long   __end
#endif
__heap_base:
        .long   0                       /* heap base address */
__heap_end:
        .long   0                       /* heap end address */
__heap_brk:
        .long   0                       /* heap brk address */
        .long   0                       /* heap offset */
        .long   __os2dll                /* list of OS/2 DLL references */
        .long   0                       /* stack base address */
        .long   0                       /* stack end address */
#if defined (OMF)
        .long   0x02000002              /* flags: application, OMF */
#else
        .long   0x02000000              /* flags: application */
#endif
        .long   0                       /* reserved */
        .long   0                       /* reserved */
        .byte   0                       /* options */
        .space  63, 0

/ first element of vector (N_SETA|N_EXT == 21)

#if defined (OMF)
__os2dll:
        .long   0, 0
#else
        .stabs  "__os2dll", 21, 0, 0, 0xffffffff
#endif

        .stabs  "___CTOR_LIST__", 21, 0, 0, 0xffffffff
        .stabs  "___DTOR_LIST__", 21, 0, 0, 0xffffffff
        .stabs  "___crtinit1__", 21, 0, 0, 0xffffffff
        .stabs  "___crtexit1__", 21, 0, 0, 0xffffffff
        .stabs  "___eh_frame__", 21, 0, 0, 0xffffffff
