/* impsockh.c (emx+gcc) -- Copyright (c) 1995-1996 by Eberhard Mattes */

#include <fcntl.h>
#include <errno.h>
#include <emx/io.h>
#include <emx/syscalls.h>

int _impsockhandle (int handle, int flags)
{
  int fd, *pflags;

  fd = __impsockhandle (handle, flags);
  if (fd == -1)
    return -1;
  if ((pflags = _fd_init (fd)) == NULL)
    {
      errno = EMFILE;
      return -1;
    }

  *pflags = O_RDWR | F_SOCKET;
  return fd;
}
