/* system.c (emx+gcc) -- Copyright (c) 1990-1995 by Eberhard Mattes */

#include <stdlib.h>
#include <string.h>
#include <process.h>
#include <io.h>
#include <errno.h>

int system (const char *name)
{
  int rc;
  const char *sh, *base, *opt;

  sh = getenv ("EMXSHELL");
  if (sh == NULL)
    sh = getenv ("COMSPEC");
  if (sh == NULL)
    {
      errno = ENOENT;
      return -1;
    }
  if (name == NULL)   /* Check for command interpreter */
    return _access (sh, 0) == 0;
  if (*name == 0)
    rc = _spawnlp (P_WAIT, sh, sh, (char *)0);
  else
    {
      base = _getname (sh);
      if (_stricmp (base, "cmd.exe") == 0 || _stricmp (base, "4os2.exe") == 0
          || _stricmp (base, "command.com") == 0
          || _stricmp (base, "4dos.com") == 0)
        opt = "/c";
      else
        opt = "-c";
      rc = _spawnlp (P_WAIT, sh, sh, opt, name, (char *)0);
    }
  return rc;
}
