/* spawnlpe.c (emx+gcc) -- Copyright (c) 1992-1995 by Eberhard Mattes */

#include <stddef.h>
#include <stdarg.h>
#include <process.h>

int _spawnlpe (int mode, const char *name, const char *arg0, ...)
{
  va_list arg_ptr;
  char * const *env_ptr;
  int result;

  va_start (arg_ptr, name);
  while (va_arg (arg_ptr, char *) != NULL)
    /* do nothing */;
  env_ptr = va_arg (arg_ptr, char * const *);
  va_end (arg_ptr);
  va_start (arg_ptr, name);

  /* Note: Passing `arg_ptr' to spawnvpe() is not portable. */

  result = _spawnvpe (mode, name, (char * const *)arg_ptr, env_ptr);
  va_end (arg_ptr);
  return result;
}
