/* pwd.c (emx+gcc) -- Copyright (c) 1990-1996 by Eberhard Mattes */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <pwd.h>
#include <emx/pwd.h>


static void path_assign (char *dst, const char *src, size_t dst_size)
{
  _strncpy (dst, src, dst_size);
  _fnslashify (dst);
}


struct passwd *_getpw (uid_t uid, const char *name)
{
  static struct passwd tmp_pwd;
  static char tmp_name[L_cuserid];
  static char tmp_dir[70];
  static char tmp_shell[70];
  const char *dir;
  const char *shell;

  if (name == NULL)
    name = getenv ("LOGNAME");
  if (name == NULL)
    name = getenv ("USER");
  if (name == NULL)
    name = "root";

  dir = getenv ("HOME");
  if (dir == NULL)
    dir = "/";

  shell = getenv ("SHELL");
  if (shell == NULL)
    shell = getenv ("COMSPEC");
  if (shell == NULL)
    shell = "/bin/sh";

  _strncpy (tmp_name, name, sizeof (tmp_name));
  path_assign (tmp_dir, dir, sizeof (tmp_dir));
  path_assign (tmp_shell, shell, sizeof (tmp_shell));
  tmp_pwd.pw_name = tmp_name;
  tmp_pwd.pw_passwd = "";
  tmp_pwd.pw_uid = uid;
  tmp_pwd.pw_gid = 0;
  tmp_pwd.pw_age = "";
  tmp_pwd.pw_comment = "";
  tmp_pwd.pw_gecos = "";
  tmp_pwd.pw_dir = tmp_dir;
  tmp_pwd.pw_shell = tmp_shell;
  return &tmp_pwd;
}


struct passwd *_getpwent (void)
{
  return NULL;                  /* End of /etc/passwd reached */
}


void _setpwent (void)
{
}


void _endpwent (void)
{
}
