/* getcwd2.c (emx+gcc) -- Copyright (c) 1992-1996 by Eberhard Mattes */

#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <sys/param.h>
#include <emx/syscalls.h>

char *_getcwd2 (char *buffer, int size)
{
  char tmp[MAXPATHLEN+1];
  int len;

  if (buffer != NULL && size <= 0)
    {
      errno = EINVAL;
      return NULL;
    }
  if (__getcwd (tmp, 0) < 0)
    return NULL;
  len = strlen (tmp) + 4;
  if (buffer != NULL)
    {
      if (len > size)
        {
          errno = ERANGE;
          return NULL;
        }
    }
  else
    {
      if (len > size)
        size = len;
      buffer = malloc (size);
      if (buffer == NULL)
        {
          errno = ENOMEM;
          return NULL;
        }
    }
  _fnslashify (tmp);
  buffer[0] = _getdrive();
  buffer[1] = ':';
  buffer[2] = '/';
  strcpy (buffer+3, tmp);
  return buffer;
}
