/ isnan.s (emx+gcc) -- Copyright (c) 1996 by Eberhard Mattes

#include <emx/asm386.h>

#define FUNC    MATHSUFFIX3(__isnan)

        .globl  LABEL(FUNC)

        .text

        ALIGN

#if defined (LONG_DOUBLE)

/ int __isnanl (long double x)

#define x       4(%esp)

LABEL(FUNC):
        PROFILE_NOFRAME
        fldt    x
        fxam
        fstsww  %ax
        fstp    %st(0)
        movb    %ah, %al
        andl    $0x47, %eax
        movb    Ltable(%eax), %al
        EPILOGUE(FUNC)

Ltable: .byte   1               /* +unnormal, not supported by 387 */
        .byte   1               /* -unnormal, not supported by 387 */
        .byte   1               /* +NaN */
        .byte   1               /* -NaN */
        .byte   0               /* +normal */
        .byte   0               /* +infinity */
        .byte   0               /* -normal */
        .byte   0               /* -infinity */
        .byte   1, 1, 1, 1, 1, 1, 1, 1
        .byte   1, 1, 1, 1, 1, 1, 1, 1
        .byte   1, 1, 1, 1, 1, 1, 1, 1
        .byte   1, 1, 1, 1, 1, 1, 1, 1
        .byte   1, 1, 1, 1, 1, 1, 1, 1
        .byte   1, 1, 1, 1, 1, 1, 1, 1
        .byte   1, 1, 1, 1, 1, 1, 1, 1
        .byte   0               /* +zero */
        .byte   1               /* empty */
        .byte   0               /* -zero */
        .byte   1               /* empty */
        .byte   0               /* +denormal */
        .byte   1               /* empty, not supported by 387 */
        .byte   0               /* -denormal */
        .byte   1               /* empty, not supported by 387 */

#elif defined (FLOAT)

/ int __isnanf (float x)

#define x       4(%esp)

LABEL(FUNC):
        PROFILE_NOFRAME
        movl    x, %edx
        xorl    %eax, %eax
        andl    $0x7fffffff, %edx
        cmpl    $0x7f800000, %edx
        seta    %al
        EPILOGUE(FUNC)

#else

/ int __isnan (double x)

#define x0      4(%esp)
#define x4      8(%esp)

LABEL(FUNC):
        PROFILE_NOFRAME
        movl    x4, %edx
        xorl    %eax, %eax
        andl    $0x7fffffff, %edx
        cmpl    $0x7ff00000, %edx
        je      Linf
        seta    %al
        ALIGN
Lreturn:EPILOGUE(FUNC)

        ALIGN
Linf:   cmpl    $0, x0
        setne   %al
        jmp     Lreturn

#endif
