/* vprintf.c (emx+gcc) -- Copyright (c) 1990-1996 by Eberhard Mattes */

#include <sys/builtin.h>        /* For <sys/fmutex.h> */
#include <sys/fmutex.h>         /* For <sys/rmutex.h> */
#include <sys/rmutex.h>
#include <stdio.h>
#include <stdlib.h>
#include <emx/io.h>

int vprintf (const char *format, va_list arg_ptr)
{
  int result;
  void *tb;

  STREAM_LOCK (stdout);
  if (nbuf (stdout))
    _fbuf (stdout);
  _tmpbuf (stdout, tb);
  result = _output (stdout, format, arg_ptr);
  if (_endbuf (stdout) != 0)
    result = -1;
  STREAM_UNLOCK (stdout);
  return result;
}
