/* vscroll.c (emx+gcc) -- Copyright (c) 1987-1994 by Eberhard Mattes */

#include <stdlib.h>
#include <sys/video.h>
#include "video2.h"
#include "video3.h"

void v_scroll (int tl_x, int tl_y, int br_x, int br_y, int count, int flag)
{
  if (count > 0)
    {
#if defined (IF_OS2)
      IF_OS2
        {
          BYTE cell[2];

          cell[0] = ' ';
          cell[1] = (BYTE)_v_attr;
          switch (flag)
            {
            case V_SCROLL_UP:
              VioScrollUp ((USHORT)tl_y, (USHORT)tl_x,
                           (USHORT)br_y, (USHORT)br_x, (USHORT)count, cell, 0);
              break;
            case V_SCROLL_DOWN:
              VioScrollDn ((USHORT)tl_y, (USHORT)tl_x,
                           (USHORT)br_y, (USHORT)br_x, (USHORT)count, cell, 0);
              break;
            case V_SCROLL_LEFT:
              VioScrollLf ((USHORT)tl_y, (USHORT)tl_x,
                           (USHORT)br_y, (USHORT)br_x, (USHORT)count, cell, 0);
              break;
            case V_SCROLL_RIGHT:
              VioScrollRt ((USHORT)tl_y, (USHORT)tl_x,
                           (USHORT)br_y, (USHORT)br_x, (USHORT)count, cell, 0);
              break;
            case V_SCROLL_CLEAR:
              VioScrollUp ((USHORT)tl_y, (USHORT)tl_x,
                           (USHORT)br_y, (USHORT)br_x,
                           (USHORT)0xffff, cell, 0);
              break;
            }
        }
#endif
#if defined (IF_DOS)
      IF_DOS
        {
          union REGS r;

          r.h.al = count;
          switch (flag)
            {
            case V_SCROLL_UP:
              r.h.ah = 0x06;
              break;
            case V_SCROLL_DOWN:
              r.h.ah = 0x07;
              break;
            case V_SCROLL_LEFT:
            case V_SCROLL_RIGHT:
              return;
            case V_SCROLL_CLEAR:
              r.h.ah = 0x06;
              r.h.al = 0;
              break;
            }
          r.h.cl = (unsigned char)tl_x;
          r.h.ch = (unsigned char)tl_y;
          r.h.dl = (unsigned char)br_x;
          r.h.dh = (unsigned char)br_y;
          r.h.bh = (unsigned char)_v_attr;
          _int86 (0x10, &r, &r);
        }
#endif
    }
}
