/* realloc.c (emx+gcc) -- Copyright (c) 1990-1996 by Eberhard Mattes */

#include <stdlib.h>
#include "malloc1.h"

/* Resize a block of memory.  If this cannot done in-place, move the
   block. */

void *realloc (void *mem, size_t new_size)
{
  void *p;

  /* First handle the trivial cases: if MEM is NULL, realloc() behaves
     like malloc(). */

  if (mem == NULL)
    return malloc (new_size);

  /* If the new size is 0, free the block. */

  if (new_size == 0)
    {
      free (mem);
      return NULL;
    }

  HEAP_LOCK;
  p = _realloc2 (mem, new_size, FALSE);
  HEAP_UNLOCK;
  return p;
}
