/* localtim.c (emx+gcc) -- Copyright (c) 1990-1999 by Eberhard Mattes */

#include "libc-alias.h"
#include <time.h>
#include <InnoTekLIBC/thread.h>
#include <emx/time.h>

struct tm *_localtime64_r(const time64_t *t, struct tm *dst)
{
    if (!_tzset_flag)
        tzset();
    time64_t lt = *t;
    int isdst = _gmt2loc64(&lt);
    struct tm *p = _gmtime64_r(&lt, dst);
    p->tm_isdst = isdst;
    return p;
}

struct tm *_STD(localtime_r)(const time_t *t, struct tm *dst)
{
    time64_t t64 = *t;
    return _localtime64_r(&t64, dst);
}

struct tm *_STD(localtime)(const time_t *t)
{
    __LIBC_PTHREAD pThrd = __libc_threadCurrent();
    return localtime_r(t, &pThrd->GmTimeAndLocalTimeBuf);
}

