/* gmtime.c (emx+gcc) -- Copyright (c) 1990-1999 by Eberhard Mattes */

#include "libc-alias.h"
#include <stdlib.h>
#include <time.h>
#include <stdint.h>
#include <InnoTekLIBC/thread.h>
#include <emx/time.h>

struct tm *_gmtime64_r(const time64_t *t, struct tm *dst)
{
    int days;
    int rem;
    time64_t t1 = *t;

    /* calc days relative to Epoch. */
    days = t1 / (60*60*24);
    rem = t1 % (60*60*24);
    while (rem < 0)
    {
        rem += (60*60*24);
        --days;
    }

    dst->tm_hour= rem / (60*60);
    rem %= (60*60);
    dst->tm_min = rem / 60;
    dst->tm_sec = rem % 60;

    dst->tm_wday = (days + 4) % 7;    /* 01-Jan-1970 was Thursday, i.e. 4 */
    if (dst->tm_wday < 0)
        dst->tm_wday += 7;

    {
        int lo, hi, i;

        /* Find an i such that _year_day[i] <= days < _year_day[i+1]. */

        lo = 0; hi = _YEARS - 1;
        for (;;)
        {
            i = (lo + hi) / 2;
            if (_year_day[i] > days)
                hi = i - 1;
            else if (_year_day[i+1] <= days)
                lo = i + 1;
            else
                break;
        }
        dst->tm_year = i;
        days -= _year_day[i];
        dst->tm_yday = days;
    }

    {
        int i;
        const unsigned short *p;

        p = (_leap_year (dst->tm_year + 1900)
             ? _month_day_leap : _month_day_non_leap);
        for (i = 0; (int)days >= p[i+1]; ++i)
            ;
        dst->tm_mon = i;
        dst->tm_mday = days - p[i] + 1;
    }
    dst->tm_isdst = -1;
    return dst;
}

struct tm *_STD(gmtime_r)(const time_t *t, struct tm *dst)
{
    time64_t t64 = *t;
    return _gmtime64_r(&t64, dst);
}

struct tm *_STD(gmtime)(const time_t *t)
{
    __LIBC_PTHREAD pThrd = __libc_threadCurrent();
    return gmtime_r(t, &pThrd->GmTimeAndLocalTimeBuf);
}
