#include <dirent.h>
#include <stdio.h>
#include <errno.h>

int main(int argc, char **argv)
{
    DIR    *pDir;
    int     rc = 0;
    printf("opendir-1: TESTING\n");

    errno = 4242;
    pDir = opendir(".");
    if (pDir)
        closedir(pDir);
    else
    {
        printf("failed to open '.'. errno=%d\n", errno);
        rc++;
    }

    errno = 4242;
    pDir = opendir("./");
    if (pDir)
        closedir(pDir);
    else
    {
        printf("failed to open './'. errno=%d\n", errno);
        rc++;
    }

    errno = 4242;
    pDir = opendir(".//");
    if (pDir)
        closedir(pDir);
    else
    {
        printf("failed to open './/'. errno=%d\n", errno);
        rc++;
    }

    errno = 4242;
    pDir = opendir("/");
    if (pDir)
        closedir(pDir);
    else
    {
        printf("failed to open '/'. errno=%d\n", errno);
        rc++;
    }


    /*
     * Summary.
     */
    if (rc)
        printf("opendir-1: FAILURE %d failures\n", rc);
    else
        printf("opendir-1: SUCCESS\n");
    return rc;
}
