/* $Id: nl_langinfo.c 1705 2004-12-06 02:19:54Z bird $ */
/** @file
 *
 * nl_langinfo.
 *
 * Copyright (c) 2004 knut st. osmundsen <bird@anduin.net>
 *
 *
 * This file is part of InnoTek LIBC.
 *
 * InnoTek LIBC is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * InnoTek LIBC is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with InnoTek LIBC; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */


/*******************************************************************************
*   Header Files                                                               *
*******************************************************************************/
#include "libc-alias.h"
#include <InnoTekLIBC/locale.h>
#include <langinfo.h>


char *_STD(nl_langinfo)(nl_item Item)
{
    switch (Item)
    {
        case D_T_FMT:
            return __libc_gLocaleTime.date_time_fmt;
        case D_FMT:
            return __libc_gLocaleTime.date_fmt;
        case T_FMT:
            return __libc_gLocaleTime.time_fmt;
        case AM_STR:
            return __libc_gLocaleTime.am;
        case PM_STR:
            return __libc_gLocaleTime.pm;

        case ABDAY_1:
        case ABDAY_2:
        case ABDAY_3:
        case ABDAY_4:
        case ABDAY_5:
        case ABDAY_6:
        case ABDAY_7:
            return __libc_gLocaleTime.swdays[Item - ABDAY_1];

        case DAY_1:
        case DAY_2:
        case DAY_3:
        case DAY_4:
        case DAY_5:
        case DAY_6:
        case DAY_7:
            return __libc_gLocaleTime.lwdays[Item - DAY_1];

        case ABMON_1:
        case ABMON_2:
        case ABMON_3:
        case ABMON_4:
        case ABMON_5:
        case ABMON_6:
        case ABMON_7:
        case ABMON_8:
        case ABMON_9:
        case ABMON_10:
        case ABMON_11:
        case ABMON_12:
            return __libc_gLocaleTime.smonths[Item - ABMON_1];

        case MON_1:
        case MON_2:
        case MON_3:
        case MON_4:
        case MON_5:
        case MON_6:
        case MON_7:
        case MON_8:
        case MON_9:
        case MON_10:
        case MON_11:
        case MON_12:
            return __libc_gLocaleTime.lmonths[Item - MON_1];

        case RADIXCHAR:
            return __libc_gLocaleLconv.s.decimal_point;
        case THOUSEP:
            return __libc_gLocaleLconv.s.thousands_sep;

        case YESSTR:
            return ""; ///@todo LC_MESSAGE
        case NOSTR:
            return ""; ///@todo LC_MESSAGE

        case CRNCYSTR:
            return __libc_gLocaleLconv.pszCrncyStr;

        case CODESET:
            //todo
            break;

        case T_FMT_AMPM:
            return __libc_gLocaleTime.ampm_fmt;

        case ERA:
            return __libc_gLocaleTime.era;

        case ERA_D_FMT:
            return __libc_gLocaleTime.era_date_fmt;

        case ERA_D_T_FMT:
            return __libc_gLocaleTime.era_date_time_fmt;

        case ERA_T_FMT:
            return __libc_gLocaleTime.era_time_fmt;

        case ALT_DIGITS:
            return __libc_gLocaleTime.alt_digits;

        case YESEXPR:
            return ""; ///@todo LC_MESSAGE
        case NOEXPR:
            return ""; ///@todo LC_MESSAGE

        case DATESEP:
            return __libc_gLocaleTime.datesep;

        case TIMESEP:
            return __libc_gLocaleTime.timesep;

        case LISTSEP:
            return __libc_gLocaleTime.listsep;
    }

    return "";
}


