/* $Id: _ctype.h 1698 2004-12-03 07:09:58Z bird $ */
/** @file
 *
 * _ctype.h - common header for ctype.h and wctype.h.
 *
 * Copyright (c) 2004 knut st. osmundsen <bird@anduin.net>
 *
 *
 * This file is part of InnoTek LIBC.
 *
 * InnoTek LIBC is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * InnoTek LIBC is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with InnoTek LIBC; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#ifndef __CTYPE_H_
#define	__CTYPE_H_

#include <sys/cdefs.h>
#include <sys/_types.h>

#if !defined(__InnoTekLIBC_locale_h__)
__BEGIN_DECLS
/**
 * Simplified Ctype structure for inline functions.
 */
extern struct
{
    /** All uppercased characters. */
    unsigned char   auchUpper[256];
    /** All lowercased characters. */
    unsigned char   auchLower[256];
    /** Bit flags for every character (for isXXX() function series). */
    unsigned short  ausfType[256];
} __libc_GLocaleCtype;

/**
 * Simplified Default Ctype structure for inline functions.
 */
extern const struct
{
    /** Bit flags for every character (for isXXX() function series). */
    unsigned short  ausfType[256];
} __libc_GLocaleCtypeDefault;
__END_DECLS
#endif /* !__InnoTekLIBC_locale_h__ */


/** Bit masks for the ausfType member of __libc_GLocaleCtype
 *  and __libc_GLocaleCtypeDefault
 *
 * @remark These have identical values to the CT_* to speed up setlocale().
 * @{
 */
#define __UPPER     0x0001      /** Upper case alphabetic character. */
#define __LOWER     0x0002      /** Lower case alphabetic character. */
#define __DIGIT     0x0004      /** Digits 0-9. */
#define __SPACE     0x0008      /** White space and line ends. */
#define __PUNCT     0x0010      /** Punctuation marks. */
#define __CNTRL     0x0020      /** Control and format characters. */
#define __BLANK     0x0040      /** Space and tab. */
#define __XDIGIT    0x0080      /** Hex digits. */
#define __ALPHA     0x0100      /** Letters and linguistic marks. */
#define __ALNUM     0x0200      /** Alphanumeric. */
#define __GRAPH     0x0400      /** All except controls and space. */
#define __PRINT     0x0800      /** Everything except controls. */
#define __NUMBER    0x1000      /** Integral number. */
#define __SYMBOL    0x2000      /** Symbol. */
#define __ASCII     0x8000      /** In standard ASCII set. */

/* BSD compatability */
#define _CTYPE_A    __ALPHA
#define _CTYPE_C    __CNTRL
#define _CTYPE_D    __DIGIT
#define _CTYPE_G    __GRAPH
#define _CTYPE_L    __LOWER
#define _CTYPE_P    __PUNCT
#define _CTYPE_S    __SPACE
#define _CTYPE_U    __UPPER
#define _CTYPE_X    __XDIGIT
#define _CTYPE_B    __BLANK
#define _CTYPE_R    __PRINT
#if 0 //later
#define	_CTYPE_I    	0x00080000L		/* Ideogram */
#define	_CTYPE_T    	0x00100000L		/* Special */
#define	_CTYPE_Q	0x00200000L		/* Phonogram */

#define	_CTYPE_SW0	0x20000000L		/* 0 width character */
#define	_CTYPE_SW1	0x40000000L		/* 1 width character */
#define	_CTYPE_SW2	0x80000000L		/* 2 width character */
#define	_CTYPE_SW3	0xc0000000L		/* 3 width character */
#define	_CTYPE_SWM	0xe0000000L		/* Mask for screen width data */
#define	_CTYPE_SWS	30			/* Bits to shift to get width */
#endif

/** @} */


__BEGIN_DECLS
int ___istype(__ct_rune_t, unsigned);
__ct_rune_t ___tolower(__ct_rune_t);
__ct_rune_t ___toupper(__ct_rune_t);
__END_DECLS

#if !defined(_DONT_USE_CTYPE_INLINE_) && \
    (defined(_USE_CTYPE_INLINE_) || defined(__GNUC__) || defined(__cplusplus))

__BEGIN_DECLS
static inline int __istype(__ct_rune_t _c, unsigned _f)
{
    return !(_c & 0xffffff00) ? (__libc_GLocaleCtype.ausfType[_c & 0xff] & (_f)) != 0 : ___istype(_c, _f);
}

static inline int __isctype(__ct_rune_t _c, unsigned _f)
{
    return (__libc_GLocaleCtypeDefault.ausfType[_c & 0xff] & (_f)) != 0;
}

static inline int __toupper(__ct_rune_t _c)
{
    return !(_c & 0xffffff00) ? __libc_GLocaleCtype.auchUpper[_c & 0xff] : ___toupper(_c);
}

static inline int __tolower(__ct_rune_t _c)
{
    return !(_c & 0xffffff00) ? __libc_GLocaleCtype.auchLower[_c & 0xff] : ___tolower(_c);
}
__END_DECLS

#else

__BEGIN_DECLS
int __istype(int, unsigned);
int __isctype(int, unsigned);
int __toupper(int);
int __tolower(int);

__END_DECLS

#endif

#endif /* !__CTYPE_H_ */
